/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.policy;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.api.notification.PolicyNotification;
import org.mule.runtime.api.notification.PolicyNotificationListener;
import org.mule.runtime.api.service.ServiceRepository;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.context.notification.MuleContextListener;
import org.mule.runtime.core.api.policy.DefaultPolicyInstance;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.policy.PolicyInstance;
import org.mule.runtime.core.api.policy.PolicyParametrization;
import org.mule.runtime.core.api.policy.PolicyPointcut;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplate;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactContextBuilder;
import org.mule.runtime.module.deployment.impl.internal.artifact.CompositeArtifactExtensionManagerFactory;
import org.mule.runtime.module.deployment.impl.internal.policy.ApplicationPolicyInstance;
import org.mule.runtime.module.deployment.impl.internal.policy.proxy.LifecycleFilterProxy;
import org.mule.runtime.module.extension.api.manager.DefaultExtensionManagerFactory;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderRepository;

public class DefaultApplicationPolicyInstance
implements ApplicationPolicyInstance {
    public static final String CLUSTER_MANAGER_ID = "_muleClusterManager";
    private final Application application;
    private final PolicyTemplate template;
    private final PolicyParametrization parametrization;
    private final ServiceRepository serviceRepository;
    private final ClassLoaderRepository classLoaderRepository;
    private final List<ArtifactPlugin> artifactPlugins;
    private final ExtensionModelLoaderRepository extensionModelLoaderRepository;
    private final MuleContextListener muleContextListener;
    private ArtifactContext policyContext;
    private PolicyInstance policyInstance;
    private ComponentBuildingDefinitionProvider runtimeComponentBuildingDefinitionProvider;

    public DefaultApplicationPolicyInstance(Application application, PolicyTemplate template, PolicyParametrization parametrization, ServiceRepository serviceRepository, ClassLoaderRepository classLoaderRepository, List<ArtifactPlugin> artifactPlugins, ExtensionModelLoaderRepository extensionModelLoaderRepository, MuleContextListener muleContextListener, ComponentBuildingDefinitionProvider runtimeComponentBuildingDefinitionProvider) {
        this.application = application;
        this.template = template;
        this.parametrization = parametrization;
        this.serviceRepository = serviceRepository;
        this.classLoaderRepository = classLoaderRepository;
        this.artifactPlugins = artifactPlugins;
        this.extensionModelLoaderRepository = extensionModelLoaderRepository;
        this.muleContextListener = muleContextListener;
        this.runtimeComponentBuildingDefinitionProvider = runtimeComponentBuildingDefinitionProvider;
    }

    private void initPolicyContext() throws InitialisationException {
        ArtifactContextBuilder artifactBuilder = ArtifactContextBuilder.newBuilder().setArtifactType(ArtifactType.POLICY).setArtifactProperties(new HashMap<String, String>(this.parametrization.getParameters())).setArtifactName(this.parametrization.getId()).setConfigurationFiles(this.parametrization.getConfig().getAbsolutePath()).setExecutionClassloader(this.template.getArtifactClassLoader().getClassLoader()).setServiceRepository(this.serviceRepository).setClassLoaderRepository(this.classLoaderRepository).setArtifactPlugins(this.artifactPlugins).setParentArtifact(this.application).setExtensionManagerFactory(new CompositeArtifactExtensionManagerFactory(this.application, this.extensionModelLoaderRepository, this.artifactPlugins, new DefaultExtensionManagerFactory())).setRuntimeComponentBuildingDefinitionProvider(this.runtimeComponentBuildingDefinitionProvider).setMuleContextListener(this.muleContextListener);
        artifactBuilder.withServiceConfigurator(customizationService -> {
            Registry applicationRegistry = this.application.getRegistry();
            customizationService.overrideDefaultServiceImpl("_mulePolicyStateHandler", applicationRegistry.lookupByName("_mulePolicyStateHandler").get());
            customizationService.overrideDefaultServiceImpl("_muleLockProvider", LifecycleFilterProxy.createLifecycleFilterProxy(applicationRegistry.lookupByName("_muleLockProvider").get()));
            customizationService.overrideDefaultServiceImpl("_defaultPersistentObjectStore", LifecycleFilterProxy.createLifecycleFilterProxy(applicationRegistry.lookupByName("_defaultPersistentObjectStore").get()));
            customizationService.overrideDefaultServiceImpl("_defaultInMemoryObjectStore", LifecycleFilterProxy.createLifecycleFilterProxy(applicationRegistry.lookupByName("_defaultInMemoryObjectStore").get()));
            customizationService.overrideDefaultServiceImpl("_muleTimeSupplier", LifecycleFilterProxy.createLifecycleFilterProxy(applicationRegistry.lookupByName("_muleTimeSupplier").get()));
            applicationRegistry.lookupByName(CLUSTER_MANAGER_ID).ifPresent(muleClusterManager -> customizationService.registerCustomServiceImpl(CLUSTER_MANAGER_ID, LifecycleFilterProxy.createLifecycleFilterProxy(muleClusterManager)));
        });
        try {
            this.policyContext = artifactBuilder.build();
            this.enableNotificationListeners(this.parametrization.getNotificationListeners());
            this.policyContext.getMuleContext().start();
        }
        catch (MuleException e) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage("Cannot create artifact context for the policy instance"), (Throwable)e, this);
        }
    }

    private void enableNotificationListeners(List<NotificationListener> notificationListeners) {
        NotificationListenerRegistry listenerRegistry = this.policyContext.getRegistry().lookupByType(NotificationListenerRegistry.class).get();
        this.policyContext.getMuleContext().getNotificationManager().addInterfaceToType(PolicyNotificationListener.class, PolicyNotification.class);
        notificationListeners.forEach(listenerRegistry::registerListener);
    }

    private void initPolicyInstance() throws InitialisationException {
        this.policyInstance = this.policyContext.getRegistry().lookupByType(DefaultPolicyInstance.class).get();
    }

    @Override
    public PolicyPointcut getPointcut() {
        return this.parametrization.getPointcut();
    }

    @Override
    public int getOrder() {
        return this.parametrization.getOrder();
    }

    @Override
    public PolicyTemplate getPolicyTemplate() {
        return this.template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialise() throws InitialisationException {
        if (this.policyInstance == null) {
            DefaultApplicationPolicyInstance defaultApplicationPolicyInstance = this;
            synchronized (defaultApplicationPolicyInstance) {
                if (this.policyContext == null) {
                    this.initPolicyContext();
                }
                this.initPolicyInstance();
            }
        }
    }

    @Override
    public void dispose() {
        if (this.policyContext != null) {
            this.policyContext.getMuleContext().dispose();
        }
    }

    @Override
    public Optional<Policy> getSourcePolicy() {
        if (this.policyInstance.getSourcePolicyChain().isPresent()) {
            return Optional.of(new Policy(this.policyInstance.getSourcePolicyChain().get(), this.parametrization.getId()));
        }
        return Optional.empty();
    }

    @Override
    public Optional<Policy> getOperationPolicy() {
        if (this.policyInstance.getOperationPolicyChain().isPresent()) {
            return Optional.of(new Policy(this.policyInstance.getOperationPolicyChain().get(), this.parametrization.getId()));
        }
        return Optional.empty();
    }
}

