/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.runtime.ValueResolvingException;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBasedParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public class ResolverSetBasedParameterResolver
implements ParameterValueResolver {
    private ResolverSet resolverSet;
    private ParameterizedModel parameterizedModel;
    private ReflectionCache reflectionCache;
    private ValueResolvingContext resolvingContext = ValueResolvingContext.from(MuleExtensionUtils.getInitialiserEvent());

    public ResolverSetBasedParameterResolver(ResolverSet resolverSet, ParameterizedModel parameterizedModel, ReflectionCache reflectionCache) {
        this.resolverSet = resolverSet;
        this.parameterizedModel = parameterizedModel;
        this.reflectionCache = reflectionCache;
    }

    @Override
    public Object getParameterValue(String parameterName) throws ValueResolvingException {
        try {
            ValueResolver<?> valueResolver = this.resolverSet.getResolvers().get(parameterName);
            if (valueResolver != null) {
                return valueResolver.resolve(this.resolvingContext);
            }
            return this.resolveFromParameterGroup(parameterName);
        }
        catch (ValueResolvingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ValueResolvingException(String.format("Error occurred trying to resolve value for the parameter [%s]", parameterName), e);
        }
    }

    private Object resolveFromParameterGroup(String parameterName) throws ValueResolvingException, MuleException {
        Optional<ValueResolver<?>> paramGroupValueResolver = this.getParameterGroupValueResolver(parameterName);
        if (paramGroupValueResolver.isPresent()) {
            ValueResolver<?> paramGroup = paramGroupValueResolver.get();
            return paramGroup.isDynamic() ? this.resolveDynamicGroup(parameterName, paramGroup) : this.resolveStaticGroup(parameterName, paramGroup);
        }
        throw new ValueResolvingException(String.format("An error occurred trying to resolve the parameter [%s]", parameterName));
    }

    private Optional<? extends ValueResolver<?>> getParameterGroupValueResolver(String parameterName) {
        Map<String, String> showInDslParameters = IntrospectionUtils.getShowInDslParameters(this.parameterizedModel);
        String parameterGroupName = showInDslParameters.get(parameterName);
        ValueResolver<?> valueResolver = null;
        if (parameterGroupName != null) {
            valueResolver = this.resolverSet.getResolvers().get(parameterGroupName);
        }
        return Optional.ofNullable(valueResolver);
    }

    private Object resolveStaticGroup(String parameterName, ValueResolver<?> paramGroup) throws MuleException, ValueResolvingException {
        Object resolve2 = paramGroup.resolve(this.resolvingContext);
        return new ObjectBasedParameterValueResolver(resolve2, this.parameterizedModel, this.reflectionCache).getParameterValue(parameterName);
    }

    private Object resolveDynamicGroup(String parameterName, ValueResolver<?> paramGroup) throws ValueResolvingException {
        if (paramGroup instanceof ParameterValueResolver) {
            return ((ParameterValueResolver)((Object)paramGroup)).getParameterValue(parameterName);
        }
        throw new ValueResolvingException(String.format("An error occurred trying to resolve the parameter [%s]", parameterName));
    }
}

