/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.util.ComponentLocationProvider;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.internal.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.policy.OperationExecutionFunction;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.core.internal.processor.ParametersResolverProcessor;
import org.mule.runtime.core.internal.util.rx.ImmediateScheduler;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.loader.java.property.FieldOperationParameterModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.runtime.DefaultExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.ExtensionComponent;
import org.mule.runtime.module.extension.internal.runtime.LazyExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.execution.OperationArgumentResolverFactory;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.operation.DefaultExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.ExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.IllegalOperationException;
import org.mule.runtime.module.extension.internal.runtime.operation.InterceptorsExecutionResult;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.operation.PrecalculatedExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.operation.ReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.TargetReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.ValueReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.VoidReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class ComponentMessageProcessor<T extends ComponentModel>
extends ExtensionComponent<T>
implements Processor,
ParametersResolverProcessor<T>,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentMessageProcessor.class);
    static final String INVALID_TARGET_MESSAGE = "Root component '%s' defines an invalid usage of operation '%s' which uses %s as %s";
    protected final ExtensionModel extensionModel;
    protected final ResolverSet resolverSet;
    protected final String target;
    protected final String targetValue;
    protected final RetryPolicyTemplate retryPolicyTemplate;
    protected ExecutionMediator executionMediator;
    protected ComponentExecutor componentExecutor;
    protected PolicyManager policyManager;
    private final ReflectionCache reflectionCache;
    protected ReturnDelegate returnDelegate;
    private String resolvedProcessorRepresentation;
    private boolean initialised = false;

    public ComponentMessageProcessor(ExtensionModel extensionModel, T componentModel, ConfigurationProvider configurationProvider, String target, String targetValue, ResolverSet resolverSet, CursorProviderFactory cursorProviderFactory, RetryPolicyTemplate retryPolicyTemplate, ExtensionManager extensionManager, PolicyManager policyManager, ReflectionCache reflectionCache) {
        super(extensionModel, componentModel, configurationProvider, cursorProviderFactory, extensionManager);
        this.extensionModel = extensionModel;
        this.resolverSet = resolverSet;
        this.target = target;
        this.targetValue = targetValue;
        this.policyManager = policyManager;
        this.retryPolicyTemplate = retryPolicyTemplate;
        this.reflectionCache = reflectionCache;
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Flux.from(publisher).flatMap(Exceptions.checkedFunction(event -> {
            Optional<ConfigurationInstance> configuration;
            if (this.getLocation() != null && ((InternalEvent)event).getInternalParameters().containsKey("core:interceptionResolvedContext")) {
                PrecalculatedExecutionContextAdapter<T> operationContext = this.getPrecalculatedContext((CoreEvent)event);
                configuration = operationContext.getConfiguration();
            } else {
                configuration = this.getConfiguration((CoreEvent)event);
            }
            Map<String, Object> resolutionResult = this.getResolutionResult((CoreEvent)event, configuration);
            return Mono.subscriberContext().flatMap(ctx -> {
                OperationExecutionFunction operationExecutionFunction;
                Scheduler currentScheduler = ctx.getOrEmpty("mule.nb.processorScheduler").map(s -> (Scheduler)s).orElse(ImmediateScheduler.IMMEDIATE_SCHEDULER);
                if (this.getLocation() != null && this.isInterceptedComponent(this.getLocation(), (InternalEvent)event) && ((InternalEvent)event).getInternalParameters().containsKey("core:interceptionResolvedContext")) {
                    PrecalculatedExecutionContextAdapter<T> operationContext = this.getPrecalculatedContext((CoreEvent)event);
                    operationExecutionFunction = (parameters, operationEvent) -> {
                        operationContext.setCurrentScheduler(currentScheduler);
                        return this.doProcessWithErrorMapping(operationEvent, operationContext);
                    };
                } else {
                    operationExecutionFunction = (parameters, operationEvent) -> {
                        ExecutionContextAdapter<T> operationContext;
                        try {
                            operationContext = this.createExecutionContext(configuration, parameters, operationEvent, currentScheduler);
                        }
                        catch (MuleException e) {
                            return Flux.error(e);
                        }
                        return this.doProcessWithErrorMapping(operationEvent, operationContext);
                    };
                }
                if (this.getLocation() != null) {
                    ((DefaultFlowCallStack)event.getFlowCallStack()).setCurrentProcessorPath(this.resolvedProcessorRepresentation);
                    return Mono.from(this.policyManager.createOperationPolicy(this, (CoreEvent)event, resolutionResult, operationExecutionFunction).process((CoreEvent)event));
                }
                return Mono.from(operationExecutionFunction.execute(resolutionResult, (CoreEvent)event));
            });
        }));
    }

    private Publisher<CoreEvent> doProcessWithErrorMapping(CoreEvent operationEvent, ExecutionContextAdapter<T> operationContext) {
        return this.doProcess(operationEvent, operationContext).onErrorMap(e -> !(e instanceof MessagingException), e -> new MessagingException(operationEvent, (Throwable)e, (Component)this));
    }

    private PrecalculatedExecutionContextAdapter<T> getPrecalculatedContext(CoreEvent event) {
        return (PrecalculatedExecutionContextAdapter)((InternalEvent)event).getInternalParameters().get("core:interceptionResolvedContext");
    }

    protected Mono<CoreEvent> doProcess(CoreEvent event, ExecutionContextAdapter<T> operationContext) {
        return this.executeOperation(operationContext).map(value -> this.asReturnValue(operationContext, value)).switchIfEmpty(Mono.fromCallable(() -> this.asReturnValue(operationContext, null))).onErrorMap(Exceptions::unwrap);
    }

    private CoreEvent asReturnValue(ExecutionContextAdapter<T> operationContext, Object value) {
        if (value instanceof CoreEvent) {
            return (CoreEvent)value;
        }
        return this.returnDelegate.asReturnValue(value, operationContext);
    }

    private Mono<Object> executeOperation(ExecutionContextAdapter operationContext) {
        return Mono.from(this.executionMediator.execute(this.componentExecutor, operationContext));
    }

    private ExecutionContextAdapter<T> createExecutionContext(Optional<ConfigurationInstance> configuration, Map<String, Object> resolvedParameters, CoreEvent event, Scheduler currentScheduler) throws MuleException {
        return new DefaultExecutionContext<ComponentModel>(this.extensionModel, configuration, resolvedParameters, this.componentModel, event, this.getCursorProviderFactory(), this.streamingManager, this, this.retryPolicyTemplate, currentScheduler, this.muleContext);
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        if (!this.initialised) {
            this.returnDelegate = this.createReturnDelegate();
            LifecycleUtils.initialiseIfNeeded(this.resolverSet, this.muleContext);
            this.componentExecutor = this.createComponentExecutor();
            this.executionMediator = this.createExecutionMediator();
            LifecycleUtils.initialiseIfNeeded(this.componentExecutor, true, this.muleContext);
            if (this.getLocation() != null) {
                this.resolvedProcessorRepresentation = ComponentLocationProvider.resolveProcessorRepresentation(this.muleContext.getConfiguration().getId(), this.getLocation().getLocation(), this);
            }
            this.initialised = true;
        }
    }

    private ComponentExecutor<T> createComponentExecutor() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        LazyValue<Supplier<Optional>> staticConfiguration = new LazyValue<Supplier<Optional>>(this::getStaticConfiguration);
        LazyValue<Supplier<ValueResolvingContext>> resolvingContext = new LazyValue<Supplier<ValueResolvingContext>>(() -> {
            CoreEvent initialiserEvent = null;
            try {
                initialiserEvent = org.mule.runtime.module.extension.api.util.MuleExtensionUtils.getInitialiserEvent();
                ValueResolvingContext valueResolvingContext = ValueResolvingContext.from(initialiserEvent, (Optional)staticConfiguration.get());
                return valueResolvingContext;
            }
            finally {
                if (initialiserEvent != null) {
                    ((BaseEventContext)initialiserEvent.getContext()).success();
                }
            }
        });
        this.componentModel.getParameterGroupModels().stream().forEach(group -> {
            if (group.getName().equals("General")) {
                group.getParameterModels().stream().filter(p -> p.getModelProperty(FieldOperationParameterModelProperty.class).isPresent()).forEach(p -> {
                    ValueResolver<?> resolver = this.resolverSet.getResolvers().get(p.getName());
                    if (resolver != null) {
                        try {
                            params.put(IntrospectionUtils.getMemberName(p), ResolverUtils.resolveValue(resolver, (ValueResolvingContext)resolvingContext.get()));
                        }
                        catch (MuleException e) {
                            throw new MuleRuntimeException(e);
                        }
                    }
                });
            } else {
                ParameterGroupDescriptor groupDescriptor = group.getModelProperty(ParameterGroupModelProperty.class).map(g -> g.getDescriptor()).orElse(null);
                if (groupDescriptor == null) {
                    return;
                }
                List<ParameterModel> fieldParameters = this.getGroupsOfFieldParameters((ParameterGroupModel)group);
                if (fieldParameters.isEmpty()) {
                    return;
                }
                ObjectBuilder groupBuilder = this.createFieldParameterGroupBuilder(groupDescriptor, fieldParameters);
                try {
                    params.put(((Field)groupDescriptor.getContainer()).getName(), groupBuilder.build((ValueResolvingContext)resolvingContext.get()));
                }
                catch (MuleException e) {
                    throw new MuleRuntimeException(e);
                }
            }
        });
        return MuleExtensionUtils.getOperationExecutorFactory(this.componentModel).createExecutor(this.componentModel, params);
    }

    private ObjectBuilder createFieldParameterGroupBuilder(ParameterGroupDescriptor groupDescriptor, List<ParameterModel> fieldParameters) {
        DefaultObjectBuilder groupBuilder = new DefaultObjectBuilder(groupDescriptor.getType().getDeclaringClass().get(), this.reflectionCache);
        fieldParameters.forEach(p -> {
            ValueResolver<?> resolver = this.resolverSet.getResolvers().get(p.getName());
            if (resolver != null) {
                Optional<Field> memberField = IntrospectionUtils.getMemberField(p);
                if (memberField.isPresent()) {
                    groupBuilder.addPropertyResolver(IntrospectionUtils.getMemberField(p).get(), resolver);
                } else {
                    groupBuilder.addPropertyResolver(p.getName(), resolver);
                }
            }
        });
        return groupBuilder;
    }

    private List<ParameterModel> getGroupsOfFieldParameters(ParameterGroupModel group) {
        return group.getParameterModels().stream().filter(p -> p.getModelProperty(FieldOperationParameterModelProperty.class).isPresent()).collect(Collectors.toList());
    }

    protected ReturnDelegate createReturnDelegate() {
        if (IntrospectionUtils.isVoid(this.componentModel)) {
            return VoidReturnDelegate.INSTANCE;
        }
        return !this.isTargetPresent() ? this.getValueReturnDelegate() : this.getTargetReturnDelegate();
    }

    protected TargetReturnDelegate getTargetReturnDelegate() {
        return new TargetReturnDelegate(this.target, this.targetValue, this.componentModel, this.expressionManager, this.cursorProviderFactory, this.muleContext);
    }

    protected ValueReturnDelegate getValueReturnDelegate() {
        return new ValueReturnDelegate(this.componentModel, this.cursorProviderFactory, this.muleContext);
    }

    protected boolean isTargetPresent() {
        if (StringUtils.isBlank((CharSequence)this.target)) {
            return false;
        }
        if (this.muleContext.getExpressionManager().isExpression(this.target)) {
            throw new IllegalOperationException(String.format(INVALID_TARGET_MESSAGE, this.getLocation().getRootContainerName(), this.componentModel.getName(), "an expression", "target"));
        }
        if (!this.muleContext.getExpressionManager().isExpression(this.targetValue)) {
            throw new IllegalOperationException(String.format(INVALID_TARGET_MESSAGE, this.getLocation().getRootContainerName(), this.componentModel.getName(), "something that is not an expression", "targetValue"));
        }
        return true;
    }

    protected Optional<String> getTarget() {
        return this.isTargetPresent() ? Optional.of(this.target) : Optional.empty();
    }

    @Override
    public void doStart() throws MuleException {
        LifecycleUtils.startIfNeeded(this.componentExecutor);
    }

    @Override
    public void doStop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.componentExecutor);
    }

    @Override
    public void doDispose() {
        LifecycleUtils.disposeIfNeeded(this.componentExecutor, LOGGER);
        this.initialised = false;
    }

    protected ExecutionMediator createExecutionMediator() {
        return new DefaultExecutionMediator<ComponentModel>(this.extensionModel, this.componentModel, this.connectionManager, this.muleContext.getErrorTypeRepository(), new DefaultExecutionMediator.ValueTransformer[0]);
    }

    @Override
    protected abstract void validateOperationConfiguration(ConfigurationProvider var1);

    @Override
    protected ParameterValueResolver getParameterValueResolver() {
        CoreEvent event = null;
        try {
            event = org.mule.runtime.module.extension.api.util.MuleExtensionUtils.getInitialiserEvent(this.muleContext);
            OperationParameterValueResolver<ComponentModel> operationParameterValueResolver = new OperationParameterValueResolver<ComponentModel>(new LazyExecutionContext<ComponentModel>(this.resolverSet, this.componentModel, this.extensionModel, ValueResolvingContext.from(event)), this.resolverSet, this.reflectionCache);
            return operationParameterValueResolver;
        }
        finally {
            if (event != null) {
                ((BaseEventContext)event.getContext()).success();
            }
        }
    }

    @Override
    public abstract ReactiveProcessor.ProcessingType getProcessingType();

    @Override
    public void resolveParameters(CoreEvent.Builder eventBuilder, BiConsumer<Map<String, Supplier<Object>>, ExecutionContext> afterConfigurer) throws MuleException {
        if (this.componentExecutor instanceof OperationArgumentResolverFactory) {
            List<Interceptor> interceptors;
            DefaultExecutionMediator mediator = (DefaultExecutionMediator)this.executionMediator;
            PrecalculatedExecutionContextAdapter<T> executionContext = new PrecalculatedExecutionContextAdapter<T>(this.createExecutionContext(eventBuilder.build()), this.componentExecutor);
            InterceptorsExecutionResult beforeExecutionResult = mediator.before(executionContext, interceptors = mediator.collectInterceptors(executionContext.getConfiguration(), executionContext.getOperationExecutor()));
            if (beforeExecutionResult.isOk()) {
                Map<String, Object> resolvedArguments = ((OperationArgumentResolverFactory)((Object)this.componentExecutor)).createArgumentResolver(this.componentModel).apply(executionContext);
                afterConfigurer.accept(resolvedArguments, executionContext);
                executionContext.changeEvent(eventBuilder.build());
            } else {
                this.disposeResolvedParameters(executionContext, interceptors);
                throw new DefaultMuleException("Interception execution for operation not ok", beforeExecutionResult.getThrowable());
            }
        }
    }

    @Override
    public void disposeResolvedParameters(ExecutionContext<T> executionContext) {
        DefaultExecutionMediator mediator = (DefaultExecutionMediator)this.executionMediator;
        List<Interceptor> interceptors = mediator.collectInterceptors(executionContext.getConfiguration(), executionContext instanceof PrecalculatedExecutionContextAdapter ? ((PrecalculatedExecutionContextAdapter)executionContext).getOperationExecutor() : this.componentExecutor);
        this.disposeResolvedParameters(executionContext, interceptors);
    }

    private void disposeResolvedParameters(ExecutionContext<T> executionContext, List<Interceptor> interceptors) {
        DefaultExecutionMediator mediator = (DefaultExecutionMediator)this.executionMediator;
        mediator.after(executionContext, null, interceptors);
    }

    private ExecutionContextAdapter<T> createExecutionContext(CoreEvent event) throws MuleException {
        Optional<ConfigurationInstance> configuration = this.getConfiguration(event);
        return this.createExecutionContext(configuration, this.getResolutionResult(event, configuration), event, ImmediateScheduler.IMMEDIATE_SCHEDULER);
    }

    private Map<String, Object> getResolutionResult(CoreEvent event, Optional<ConfigurationInstance> configuration) throws MuleException {
        return this.resolverSet.resolve(ValueResolvingContext.from(event, configuration)).asMap();
    }

    private boolean isInterceptedComponent(ComponentLocation location, InternalEvent event) {
        if (event.getInternalParameters().containsKey("core:interceptionComponent")) {
            Component component = (Component)event.getInternalParameters().get("core:interceptionComponent");
            return location.equals(component.getLocation());
        }
        return false;
    }
}

