/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.service.http.impl.service.server.grizzly.HttpMimeMultipart;

public class HttpMultipartEncoder {
    private static final String FORM_DATA = "form-data";
    public static final String ATTACHMENT = "attachment";
    private static final String RELATED = "related";
    private static final String TYPE_PARAMETER = "type";
    private static final String START_PARAMETER = "start";
    public static final String MANDATORY_TYPE_ERROR_MESSAGE = "Type parameter is not present in multipart/related content type, but it is mandatory.";
    public static final String AMBIGUOUS_TYPE_ERROR_MESSAGE = "Type parameter and root body part content type must be the same.";

    private HttpMultipartEncoder() {
    }

    public static MimeMultipart toMimeMultipart(HttpEntity body2, String contentType) throws IOException {
        String contentTypeSubType = HttpMultipartEncoder.getContentTypeSubType(contentType);
        String typeParameter = HttpMultipartEncoder.getContentTypeParameter(contentType, TYPE_PARAMETER);
        if (contentTypeSubType.equals(RELATED) && typeParameter == null) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(MANDATORY_TYPE_ERROR_MESSAGE));
        }
        HttpMimeMultipart mimeMultipartContent = new HttpMimeMultipart(contentType, contentTypeSubType);
        Collection<HttpPart> parts = body2.getParts();
        for (HttpPart part : parts) {
            InternetHeaders internetHeaders = new InternetHeaders();
            for (String headerName : part.getHeaderNames()) {
                Collection<String> headerValues = part.getHeaders(headerName);
                for (String headerValue : headerValues) {
                    internetHeaders.addHeader(headerName, headerValue);
                }
            }
            if (internetHeaders.getHeader("Content-Disposition") == null) {
                String partType = contentTypeSubType.equals(FORM_DATA) ? FORM_DATA : ATTACHMENT;
                internetHeaders.addHeader("Content-Disposition", HttpMultipartEncoder.getContentDisposition(part, partType));
            }
            if (contentTypeSubType.equals(RELATED) && part.getName() != null) {
                internetHeaders.addHeader("Content-Id", part.getName());
            }
            if (internetHeaders.getHeader("Content-Type") == null && part.getContentType() != null) {
                internetHeaders.addHeader("Content-Type", part.getContentType());
            }
            try {
                byte[] partContent = IOUtils.toByteArray(part.getInputStream());
                String rootContentId = HttpMultipartEncoder.getContentTypeParameter(contentType, START_PARAMETER);
                if (contentTypeSubType.equals(RELATED) && part.getName() != null && part.getName().equals(rootContentId)) {
                    mimeMultipartContent.addBodyPart((BodyPart)new MimeBodyPart(internetHeaders, partContent), 0);
                    continue;
                }
                mimeMultipartContent.addBodyPart((BodyPart)new MimeBodyPart(internetHeaders, partContent));
            }
            catch (Exception e) {
                throw new MuleRuntimeException(e);
            }
        }
        try {
            String rootBodyPartContentType;
            if (contentTypeSubType.equals(RELATED) && mimeMultipartContent.getCount() > 0 && (rootBodyPartContentType = mimeMultipartContent.getBodyPart(0).getContentType()) != null && !rootBodyPartContentType.equals(typeParameter)) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(AMBIGUOUS_TYPE_ERROR_MESSAGE));
            }
        }
        catch (MessagingException e) {
            throw new MuleRuntimeException(e);
        }
        return mimeMultipartContent;
    }

    public static byte[] toByteArray(HttpEntity multipartEntity, String contentType) throws IOException {
        MimeMultipart mimeMultipartContent = HttpMultipartEncoder.toMimeMultipart(multipartEntity, contentType);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            mimeMultipartContent.writeTo((OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (MessagingException e) {
            throw new IOException(e);
        }
    }

    private static String getContentTypeSubType(String contentType) {
        try {
            ContentType contentTypeValue = new ContentType(contentType);
            return contentTypeValue.getSubType();
        }
        catch (ParseException e) {
            throw new MuleRuntimeException(e);
        }
    }

    private static String getContentDisposition(HttpPart part, String partType) {
        StringBuilder builder = new StringBuilder();
        builder.append(partType);
        builder.append("; name=\"");
        builder.append(part.getName());
        builder.append("\"");
        if (part.getFileName() != null) {
            builder.append("; filename=\"");
            builder.append(part.getFileName());
            builder.append("\"");
        }
        return builder.toString();
    }

    public static String getContentTypeParameter(String contentType, String parameterName) {
        try {
            ContentType contentTypeValue = new ContentType(contentType);
            return contentTypeValue.getParameter(parameterName);
        }
        catch (ParseException e) {
            throw new MuleRuntimeException(e);
        }
    }
}

