/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.InnerConsumer;
import reactor.core.publisher.Operators;
import reactor.core.publisher.QueueDrainSubscriber;
import reactor.util.annotation.Nullable;
import reactor.util.concurrent.MpscLinkedQueue;

final class FluxBufferWhen<T, OPEN, CLOSE, BUFFER extends Collection<? super T>>
extends FluxOperator<T, BUFFER> {
    final Publisher<OPEN> start;
    final Function<? super OPEN, ? extends Publisher<CLOSE>> end;
    final Supplier<BUFFER> bufferSupplier;
    final Supplier<? extends Queue<BUFFER>> queueSupplier;

    FluxBufferWhen(Flux<? extends T> source, Publisher<OPEN> start, Function<? super OPEN, ? extends Publisher<CLOSE>> end, Supplier<BUFFER> bufferSupplier, Supplier<? extends Queue<BUFFER>> queueSupplier) {
        super(source);
        this.start = Objects.requireNonNull(start, "start");
        this.end = Objects.requireNonNull(end, "end");
        this.bufferSupplier = Objects.requireNonNull(bufferSupplier, "bufferSupplier");
        this.queueSupplier = Objects.requireNonNull(queueSupplier, "queueSupplier");
    }

    @Override
    public int getPrefetch() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void subscribe(CoreSubscriber<? super BUFFER> actual) {
        BufferWhenMainSubscriber main = new BufferWhenMainSubscriber(actual, this.bufferSupplier, this.end);
        actual.onSubscribe(main);
        BufferWhenOpenSubscriber bos = new BufferWhenOpenSubscriber(main);
        if (main.resources.add(bos)) {
            main.bos = bos;
            BufferWhenMainSubscriber.WINDOWS.lazySet(main, 1);
            this.start.subscribe(bos);
            this.source.subscribe(main);
        }
    }

    static final class BufferWhenCloseSubscriber<T, OPEN, CLOSE, BUFFER extends Collection<? super T>>
    implements Disposable,
    InnerConsumer<CLOSE> {
        volatile Subscription subscription;
        static final AtomicReferenceFieldUpdater<BufferWhenCloseSubscriber, Subscription> SUBSCRIPTION = AtomicReferenceFieldUpdater.newUpdater(BufferWhenCloseSubscriber.class, Subscription.class, "subscription");
        final BufferWhenMainSubscriber<T, OPEN, CLOSE, BUFFER> parent;
        final BUFFER value;
        boolean done;

        BufferWhenCloseSubscriber(BUFFER value, BufferWhenMainSubscriber<T, OPEN, CLOSE, BUFFER> parent) {
            this.parent = parent;
            this.value = value;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(SUBSCRIPTION, this, s)) {
                this.subscription.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void dispose() {
            Operators.terminate(SUBSCRIPTION, this);
        }

        @Override
        public boolean isDisposed() {
            return this.subscription == Operators.cancelledSubscription();
        }

        public void onNext(CLOSE t) {
            this.onComplete();
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.parent.actual.currentContext());
                return;
            }
            this.parent.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.parent.close(this.value, this);
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.ACTUAL) {
                return this.parent;
            }
            if (key == Scannable.Attr.PARENT) {
                return this.subscription;
            }
            if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
                return Long.MAX_VALUE;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.isDisposed();
            }
            return null;
        }
    }

    static final class BufferWhenOpenSubscriber<T, OPEN, CLOSE, BUFFER extends Collection<? super T>>
    implements Disposable,
    InnerConsumer<OPEN> {
        volatile Subscription subscription;
        static final AtomicReferenceFieldUpdater<BufferWhenOpenSubscriber, Subscription> SUBSCRIPTION = AtomicReferenceFieldUpdater.newUpdater(BufferWhenOpenSubscriber.class, Subscription.class, "subscription");
        final BufferWhenMainSubscriber<T, OPEN, CLOSE, BUFFER> parent;
        boolean done;

        BufferWhenOpenSubscriber(BufferWhenMainSubscriber<T, OPEN, CLOSE, BUFFER> parent) {
            this.parent = parent;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(SUBSCRIPTION, this, s)) {
                this.subscription.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void dispose() {
            Operators.terminate(SUBSCRIPTION, this);
        }

        @Override
        public boolean isDisposed() {
            return this.subscription == Operators.cancelledSubscription();
        }

        public void onNext(OPEN t) {
            if (this.done) {
                return;
            }
            this.parent.open(t);
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.parent.actual.currentContext());
                return;
            }
            this.done = true;
            this.parent.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.parent.openFinished(this);
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.ACTUAL) {
                return this.parent;
            }
            if (key == Scannable.Attr.PARENT) {
                return this.subscription;
            }
            if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
                return Long.MAX_VALUE;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.isDisposed();
            }
            return null;
        }
    }

    static final class BufferWhenMainSubscriber<T, OPEN, CLOSE, BUFFER extends Collection<? super T>>
    extends QueueDrainSubscriber<T, BUFFER, BUFFER>
    implements Disposable {
        final Function<? super OPEN, ? extends Publisher<? extends CLOSE>> bufferClose;
        final Supplier<BUFFER> bufferSupplier;
        final Disposable.Composite resources;
        Subscription s;
        final List<BUFFER> buffers;
        volatile int windows;
        static final AtomicIntegerFieldUpdater<BufferWhenMainSubscriber> WINDOWS = AtomicIntegerFieldUpdater.newUpdater(BufferWhenMainSubscriber.class, "windows");
        BufferWhenOpenSubscriber<T, OPEN, CLOSE, BUFFER> bos;

        BufferWhenMainSubscriber(CoreSubscriber<? super BUFFER> actual, Supplier<BUFFER> bufferSupplier, Function<? super OPEN, ? extends Publisher<? extends CLOSE>> bufferClose) {
            super(actual, new MpscLinkedQueue());
            this.bufferClose = bufferClose;
            this.bufferSupplier = bufferSupplier;
            this.buffers = new LinkedList<BUFFER>();
            this.resources = Disposables.composite();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                s.request(Long.MAX_VALUE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(T t) {
            BufferWhenMainSubscriber bufferWhenMainSubscriber = this;
            synchronized (bufferWhenMainSubscriber) {
                for (Collection b : this.buffers) {
                    b.add(t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            this.cancel();
            this.cancelled = true;
            BufferWhenMainSubscriber bufferWhenMainSubscriber = this;
            synchronized (bufferWhenMainSubscriber) {
                this.buffers.clear();
            }
            this.actual.onError(t);
        }

        public void onComplete() {
            this.done = true;
            this.resources.remove(this.bos);
            this.bos.dispose();
            if (WINDOWS.decrementAndGet(this) == 0) {
                this.complete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void complete() {
            ArrayList<BUFFER> list;
            BufferWhenMainSubscriber bufferWhenMainSubscriber = this;
            synchronized (bufferWhenMainSubscriber) {
                list = new ArrayList<BUFFER>(this.buffers);
                this.buffers.clear();
            }
            Queue q = this.queue;
            for (Collection u : list) {
                q.offer(u);
            }
            this.done = true;
            if (this.enter()) {
                BufferWhenMainSubscriber.drainMaxLoop(q, this.actual, false, this, this);
            }
        }

        public void request(long n) {
            this.requested(n);
        }

        @Override
        public void dispose() {
            this.resources.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.resources.isDisposed();
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.dispose();
            }
        }

        @Override
        public boolean accept(Subscriber<? super BUFFER> a, BUFFER v) {
            a.onNext(v);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void open(OPEN window) {
            Publisher<? extends CLOSE> p;
            Collection b;
            if (this.cancelled) {
                return;
            }
            try {
                b = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The buffer supplied is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.onError(e);
                return;
            }
            try {
                p = Objects.requireNonNull(this.bufferClose.apply(window), "The buffer closing publisher is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.onError(e);
                return;
            }
            if (this.cancelled) {
                return;
            }
            BufferWhenMainSubscriber e = this;
            synchronized (e) {
                if (this.cancelled) {
                    return;
                }
                this.buffers.add(b);
            }
            BufferWhenCloseSubscriber bcs = new BufferWhenCloseSubscriber(b, this);
            this.resources.add(bcs);
            WINDOWS.getAndIncrement(this);
            p.subscribe(bcs);
        }

        void openFinished(Disposable d) {
            if (this.resources.remove(d) && WINDOWS.decrementAndGet(this) == 0) {
                this.complete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close(BUFFER b, Disposable d) {
            boolean e;
            BufferWhenMainSubscriber bufferWhenMainSubscriber = this;
            synchronized (bufferWhenMainSubscriber) {
                e = this.buffers.remove(b);
            }
            if (e) {
                this.fastPathOrderedEmitMax(b, false, this);
            }
            if (this.resources.remove(d) && WINDOWS.decrementAndGet(this) == 0) {
                this.complete();
            }
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.PREFETCH) {
                return Integer.MAX_VALUE;
            }
            if (key == Scannable.Attr.BUFFERED) {
                return this.buffers.stream().mapToInt(Collection::size).sum();
            }
            return super.scanUnsafe(key);
        }
    }
}

