/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.connector;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.privileged.connector.ReplyToHandler;
import org.mule.runtime.core.privileged.store.DeserializationPostInitialisable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultReplyToHandler
implements ReplyToHandler,
Serializable,
DeserializationPostInitialisable {
    private static final long serialVersionUID = 1L;
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected transient Map<String, Object> serializedData = null;

    @Override
    public CoreEvent processReplyTo(CoreEvent event, Message returnMessage, Object replyTo) throws MuleException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("sending reply to: " + replyTo);
        }
        return CoreEvent.builder(event).removeVariable("MULE_REPLYTO").removeVariable("MULE_REMOTE_SYNC").message(InternalMessage.builder(event.getMessage()).removeOutboundProperty("MULE_REMOTE_SYNC").build()).build();
    }

    public void initAfterDeserialisation(MuleContext context) throws MuleException {
        if (this.serializedData == null) {
            return;
        }
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.serializedData = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        String connectorName = null;
        String connectorType = null;
        if (this.serializedData != null) {
            connectorName = (String)this.serializedData.get("connectorName");
            connectorType = (String)this.serializedData.get("connectorType");
        }
        out.writeObject(connectorName);
        out.writeObject(connectorType);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.serializedData = new HashMap<String, Object>();
        this.serializedData.put("connectorName", in.readObject());
        this.serializedData.put("connectorType", in.readObject());
    }
}

