/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.util;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ParameterGroupObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.extension.internal.util.ValueSetter;
import org.springframework.util.ReflectionUtils;

public final class GroupValueSetter
implements ValueSetter {
    private final ParameterGroupDescriptor groupDescriptor;
    private final Field container;
    private final Supplier<ReflectionCache> reflectionCache;

    public static List<ValueSetter> settersFor(ParameterizedModel model, Supplier<ReflectionCache> reflectionCache) {
        ImmutableList.Builder setters = ImmutableList.builder();
        model.getParameterGroupModels().stream().filter(group -> !group.isShowInDsl()).filter(group -> !group.getName().equals("General")).forEach(group -> group.getModelProperty(ParameterGroupModelProperty.class).ifPresent(arg_0 -> GroupValueSetter.lambda$null$2(setters, (Supplier)reflectionCache, arg_0)));
        return setters.build();
    }

    public GroupValueSetter(ParameterGroupDescriptor groupDescriptor, Supplier<ReflectionCache> reflectionCache) {
        this.groupDescriptor = groupDescriptor;
        Preconditions.checkArgument(groupDescriptor.getContainer() instanceof Field, "Only field contained parameter groups are allowed");
        this.container = (Field)groupDescriptor.getContainer();
        this.reflectionCache = reflectionCache;
    }

    @Override
    public void set(Object target, ResolverSetResult result) throws MuleException {
        this.container.setAccessible(true);
        ReflectionUtils.setField((Field)this.container, (Object)target, new ParameterGroupObjectBuilder(this.groupDescriptor, this.reflectionCache.get()).build(result));
    }

    private static /* synthetic */ void lambda$null$2(ImmutableList.Builder setters, Supplier reflectionCache, ParameterGroupModelProperty property) {
        if (property.getDescriptor().getContainer() instanceof Field) {
            setters.add((Object)new GroupValueSetter(property.getDescriptor(), reflectionCache));
        }
    }
}

