/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.streaming;

import java.io.InputStream;
import javax.inject.Inject;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.streaming.StreamingStatistics;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.api.streaming.bytes.ByteStreamingManager;
import org.mule.runtime.core.api.streaming.object.ObjectStreamingManager;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.internal.streaming.CursorManager;
import org.mule.runtime.core.internal.streaming.ManagedCursorProvider;
import org.mule.runtime.core.internal.streaming.MutableStreamingStatistics;
import org.mule.runtime.core.internal.streaming.bytes.DefaultByteStreamingManager;
import org.mule.runtime.core.internal.streaming.bytes.PoolingByteBufferManager;
import org.mule.runtime.core.internal.streaming.object.DefaultObjectStreamingManager;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoExtend
public class DefaultStreamingManager
implements StreamingManager,
Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStreamingManager.class);
    private ByteBufferManager bufferManager;
    private ByteStreamingManager byteStreamingManager;
    private ObjectStreamingManager objectStreamingManager;
    private CursorManager cursorManager;
    private MutableStreamingStatistics statistics;
    private boolean initialised = false;
    private Scheduler allocationScheduler;
    @Inject
    private MuleContext muleContext;
    @Inject
    private SchedulerService schedulerService;

    @Override
    public void initialise() throws InitialisationException {
        if (!this.initialised) {
            this.statistics = new MutableStreamingStatistics();
            this.allocationScheduler = this.schedulerService.ioScheduler(this.muleContext.getSchedulerBaseConfig().withName("StreamingManager-allocate"));
            this.cursorManager = new CursorManager(this.statistics);
            this.bufferManager = new PoolingByteBufferManager(this.allocationScheduler);
            this.byteStreamingManager = this.createByteStreamingManager();
            this.objectStreamingManager = this.createObjectStreamingManager();
            LifecycleUtils.initialiseIfNeeded(this.byteStreamingManager, true, this.muleContext);
            LifecycleUtils.initialiseIfNeeded(this.objectStreamingManager, true, this.muleContext);
            this.initialised = true;
        }
    }

    protected ByteStreamingManager createByteStreamingManager() {
        return new DefaultByteStreamingManager(this.bufferManager, this);
    }

    protected ObjectStreamingManager createObjectStreamingManager() {
        return new DefaultObjectStreamingManager(this);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.byteStreamingManager, LOGGER);
        LifecycleUtils.disposeIfNeeded(this.objectStreamingManager, LOGGER);
        LifecycleUtils.disposeIfNeeded(this.bufferManager, LOGGER);
        LifecycleUtils.disposeIfNeeded(this.cursorManager, LOGGER);
        this.allocationScheduler.stop();
        this.initialised = false;
    }

    @Override
    public ByteStreamingManager forBytes() {
        return this.byteStreamingManager;
    }

    @Override
    public ObjectStreamingManager forObjects() {
        return this.objectStreamingManager;
    }

    @Override
    public CursorProvider manage(CursorProvider provider, EventContext creatorEventContext) {
        if (provider instanceof ManagedCursorProvider) {
            return provider;
        }
        return this.cursorManager.manage(provider, (BaseEventContext)creatorEventContext);
    }

    @Override
    public void manage(InputStream stream, EventContext creatorEventContext) {
        if (stream instanceof Cursor) {
            return;
        }
        ((BaseEventContext)creatorEventContext).onTerminated((response, throwable) -> IOUtils.closeQuietly(stream));
    }

    @Override
    public CursorProvider manage(CursorProvider provider, CoreEvent creatorEvent) {
        return this.manage(provider, (EventContext)((BaseEventContext)creatorEvent.getContext()).getRootContext());
    }

    @Override
    public void manage(InputStream stream, CoreEvent creatorEvent) {
        this.manage(stream, (EventContext)((BaseEventContext)creatorEvent.getContext()).getRootContext());
    }

    @Override
    public StreamingStatistics getStreamingStatistics() {
        return this.statistics;
    }

    protected ByteBufferManager getBufferManager() {
        return this.bufferManager;
    }
}

