/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el.context;

import java.io.Serializable;
import java.util.Map;
import javax.activation.DataHandler;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.transformer.MessageTransformerException;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.el.context.InboundAttachmentMapContext;
import org.mule.runtime.core.internal.el.context.InboundPropertiesMapContext;
import org.mule.runtime.core.internal.el.context.OutboundAttachmentMapContext;
import org.mule.runtime.core.internal.el.context.OutboundPropertiesMapContext;

public class MessageContext {
    private CoreEvent event;
    private CoreEvent.Builder eventBuilder;
    private MuleContext muleContext;

    public MessageContext(CoreEvent event, CoreEvent.Builder eventBuilder, MuleContext muleContext) {
        this.event = event;
        this.eventBuilder = eventBuilder;
        this.muleContext = muleContext;
    }

    public String getCorrelationId() {
        return this.event.getCorrelationId();
    }

    public int getCorrelationSequence() {
        return this.event.getGroupCorrelation().map(gc -> gc.getSequence()).orElse(-1);
    }

    public int getCorrelationGroupSize() {
        return this.event.getGroupCorrelation().map(gc -> gc.getGroupSize().orElse(-1)).orElse(-1);
    }

    public DataType getDataType() {
        return this.event.getMessage().getPayload().getDataType();
    }

    public Object getPayload() {
        return this.event.getMessage().getPayload() != null ? this.event.getMessage().getPayload().getValue() : null;
    }

    public <T> T payloadAs(Class<T> type) throws TransformerException {
        this.eventBuilder.message(this.muleContext.getTransformationService().transform(this.event.getMessage(), DataType.fromType(type)));
        this.event = this.eventBuilder.build();
        return this.event.getMessage().getPayload().getValue();
    }

    public Object payloadAs(DataType dataType) throws MessageTransformerException {
        this.eventBuilder.message(this.muleContext.getTransformationService().transform(this.event.getMessage(), dataType));
        this.event = this.eventBuilder.build();
        return this.event.getMessage().getPayload().getValue();
    }

    public void setPayload(Object payload) {
        this.eventBuilder.message(Message.builder(this.event.getMessage()).value(payload).build());
        this.event = this.eventBuilder.build();
    }

    public Map<String, Serializable> getInboundProperties() {
        return new InboundPropertiesMapContext(this.event);
    }

    public Map<String, Serializable> getOutboundProperties() {
        return new OutboundPropertiesMapContext(this.event, this.eventBuilder);
    }

    public Map<String, DataHandler> getInboundAttachments() {
        return new InboundAttachmentMapContext(this.event);
    }

    public Map<String, DataHandler> getOutboundAttachments() {
        return new OutboundAttachmentMapContext(this.event, this.eventBuilder);
    }

    public Object getAttributes() {
        return this.event.getMessage().getAttributes() != null ? this.event.getMessage().getAttributes().getValue() : null;
    }

    public DataType getAttributesDataType() {
        return this.event.getMessage().getAttributes().getDataType();
    }

    public String toString() {
        return this.event.getMessage().toString();
    }
}

