/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.AbstractStreamProcessingStrategyFactory;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class ReactorStreamProcessingStrategyFactory
extends AbstractStreamProcessingStrategyFactory {
    @Override
    public ProcessingStrategy create(MuleContext muleContext, String schedulersNamePrefix) {
        return new ReactorStreamProcessingStrategy(this.getRingBufferSchedulerSupplier(muleContext, schedulersNamePrefix), this.getBufferSize(), this.getSubscriberCount(), this.getWaitStrategy(), this.getCpuLightSchedulerSupplier(muleContext, schedulersNamePrefix), this.resolveParallelism(), this.getMaxConcurrency());
    }

    protected int resolveParallelism() {
        if (this.getMaxConcurrency() == Integer.MAX_VALUE) {
            return Math.max(CORES / this.getSubscriberCount(), 1);
        }
        return Math.min(CORES, Math.max(this.getMaxConcurrency() / this.getSubscriberCount(), 1));
    }

    protected Supplier<org.mule.runtime.api.scheduler.Scheduler> getCpuLightSchedulerSupplier(MuleContext muleContext, String schedulersNamePrefix) {
        return () -> muleContext.getSchedulerService().cpuLightScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.CPU_LITE.name()));
    }

    @Override
    public Class<? extends ProcessingStrategy> getProcessingStrategyType() {
        return ReactorStreamProcessingStrategy.class;
    }

    static class ReactorStreamProcessingStrategy
    extends AbstractStreamProcessingStrategyFactory.AbstractStreamProcessingStrategy
    implements Startable,
    Stoppable {
        private final Supplier<org.mule.runtime.api.scheduler.Scheduler> cpuLightSchedulerSupplier;
        private org.mule.runtime.api.scheduler.Scheduler cpuLightScheduler;
        private final int parallelism;

        ReactorStreamProcessingStrategy(Supplier<org.mule.runtime.api.scheduler.Scheduler> ringBufferSchedulerSupplier, int bufferSize, int subscribers, String waitStrategy, Supplier<org.mule.runtime.api.scheduler.Scheduler> cpuLightSchedulerSupplier, int parallelism, int maxConcurrency) {
            super(ringBufferSchedulerSupplier, bufferSize, subscribers, waitStrategy, maxConcurrency);
            this.cpuLightSchedulerSupplier = cpuLightSchedulerSupplier;
            this.parallelism = parallelism;
        }

        @Override
        public ReactiveProcessor onPipeline(ReactiveProcessor pipeline) {
            Scheduler scheduler = Schedulers.fromExecutorService(this.decorateScheduler(this.getCpuLightScheduler()));
            if (this.maxConcurrency > this.subscribers) {
                return publisher -> Flux.from(publisher).parallel(this.parallelism).runOn(scheduler).composeGroup(super.onPipeline(pipeline));
            }
            return super.onPipeline(pipeline);
        }

        @Override
        public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
            Scheduler scheduler = Schedulers.fromExecutorService(this.decorateScheduler(this.getCpuLightScheduler()));
            if (processor.getProcessingType() == ReactiveProcessor.ProcessingType.CPU_LITE_ASYNC) {
                return publisher -> Flux.from(publisher).transform(processor).subscriberContext(ctx -> ctx.put("mule.nb.processorScheduler", this.getCpuLightScheduler())).parallel(this.parallelism).runOn(scheduler);
            }
            return publisher -> Flux.from(publisher).transform(processor).subscriberContext(ctx -> ctx.put("mule.nb.processorScheduler", this.getCpuLightScheduler()));
        }

        protected int getParallelism() {
            return this.parallelism;
        }

        @Override
        public void start() throws MuleException {
            this.cpuLightScheduler = this.cpuLightSchedulerSupplier.get();
        }

        @Override
        public void stop() throws MuleException {
            if (this.cpuLightScheduler != null) {
                this.cpuLightScheduler.stop();
            }
        }

        protected org.mule.runtime.api.scheduler.Scheduler getCpuLightScheduler() {
            return this.cpuLightScheduler;
        }
    }
}

