/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.registry;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.privileged.component.AnnotatedObjectInvocationHandler;
import org.mule.runtime.core.privileged.registry.RegistrationException;

public class DefaultRegistry
implements Registry {
    private static final Function<Object, Object> deAnnotator = s -> s == null ? null : AnnotatedObjectInvocationHandler.removeDynamicAnnotations(s);
    private MuleContextWithRegistries muleContext;

    public DefaultRegistry(MuleContext muleContext) {
        this.muleContext = (MuleContextWithRegistries)muleContext;
    }

    @Override
    public <T> Optional<T> lookupByType(Class<T> objectType) {
        try {
            return Optional.ofNullable(this.muleContext.getRegistry().lookupObject(objectType));
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public <T> Optional<T> lookupByName(String name) {
        return Optional.ofNullable(this.muleContext.getRegistry().lookupObject(name));
    }

    @Override
    public <T> Collection<T> lookupAllByType(Class<T> serviceType) {
        return this.muleContext.getRegistry().lookupObjects(serviceType);
    }
}

