/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.exception;

import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.TypedException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.message.ErrorBuilder;

public class EventProcessingException
extends MuleException {
    private static final long serialVersionUID = 8849038142532938068L;
    protected final transient CoreEvent event;

    public EventProcessingException(I18nMessage message, CoreEvent event) {
        super(message);
        this.event = event;
    }

    public EventProcessingException(I18nMessage message, CoreEvent event, Throwable cause) {
        super(message, EventProcessingException.getCause(cause));
        this.event = EventProcessingException.getEvent(event, cause);
    }

    public EventProcessingException(CoreEvent event, Throwable cause) {
        super(EventProcessingException.getCause(cause));
        this.event = EventProcessingException.getEvent(event, cause);
    }

    public CoreEvent getEvent() {
        return this.event;
    }

    public Component getFailingComponent() {
        return null;
    }

    private static Throwable getCause(Throwable cause) {
        return cause instanceof TypedException ? cause.getCause() : cause;
    }

    private static CoreEvent getEvent(CoreEvent event, Throwable cause) {
        return cause instanceof TypedException ? EventProcessingException.eventWithError(event, (TypedException)cause) : event;
    }

    private static CoreEvent eventWithError(CoreEvent event, TypedException cause) {
        return CoreEvent.builder(event).error(ErrorBuilder.builder(cause.getCause()).errorType(cause.getErrorType()).build()).build();
    }
}

