/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.internal.ContainerClassLoaderFilterFactory;
import org.mule.runtime.container.internal.ContainerModuleDiscoverer;
import org.mule.runtime.container.internal.ContainerOnlyLookupStrategy;
import org.mule.runtime.container.internal.DefaultModuleRepository;
import org.mule.runtime.container.internal.FilteringContainerClassLoader;
import org.mule.runtime.container.internal.MuleClassLoaderLookupPolicy;
import org.mule.runtime.core.internal.util.EnumerationAdapter;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.ExportedService;
import org.mule.runtime.module.artifact.api.classloader.FilteringArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;

public class ContainerClassLoaderFactory {
    public static final String MULE_ALLOW_JRE_EXTENSION = "mule.classloading.jreExtension";
    public static final String MULE_JRE_EXTENSION_PACKAGES = "mule.classloading.jreExtension.packages";
    private static final String DEFAULT_JRE_EXTENSION_PACKAGES = "javax.,org.w3c.dom,org.omg.,org.xml.sax,org.ietf.jgss";
    private static final boolean ALLOW_JRE_EXTENSION = Boolean.valueOf(System.getProperty("mule.classloading.jreExtension", "true"));
    private static final String[] JRE_EXTENDABLE_PACKAGES = System.getProperty("mule.classloading.jreExtension.packages", "javax.,org.w3c.dom,org.omg.,org.xml.sax,org.ietf.jgss").split(",");
    public static final Set<String> SYSTEM_PACKAGES = ImmutableSet.of((Object)"org.mule.runtime", (Object)"com.mulesoft.mule.runtime");
    public static final Set<String> BOOT_PACKAGES = ImmutableSet.of((Object)"com.yourkit");
    private final ModuleRepository moduleRepository;

    public ContainerClassLoaderFactory(ModuleRepository moduleRepository) {
        Preconditions.checkArgument(moduleRepository != null, "moduleRepository cannot be null");
        this.moduleRepository = moduleRepository;
    }

    public ContainerClassLoaderFactory() {
        this(new DefaultModuleRepository(new ContainerModuleDiscoverer(ContainerClassLoaderFactory.class.getClassLoader())));
    }

    public ArtifactClassLoader createContainerClassLoader(ClassLoader parentClassLoader) {
        List<MuleModule> muleModules = this.moduleRepository.getModules();
        ClassLoaderLookupPolicy containerLookupPolicy = this.getContainerClassLoaderLookupPolicy(parentClassLoader, muleModules);
        return this.createArtifactClassLoader(parentClassLoader, muleModules, containerLookupPolicy, new ArtifactDescriptor("mule"));
    }

    protected ClassLoaderLookupPolicy getContainerClassLoaderLookupPolicy(ClassLoader parentClassLoader, List<MuleModule> muleModules) {
        HashSet<String> parentOnlyPackages = new HashSet<String>(this.getBootPackages());
        parentOnlyPackages.addAll(SYSTEM_PACKAGES);
        Map<String, LookupStrategy> lookupStrategies = this.buildClassLoaderLookupStrategy(parentClassLoader, muleModules);
        return new MuleClassLoaderLookupPolicy(lookupStrategies, parentOnlyPackages);
    }

    protected ArtifactClassLoader createArtifactClassLoader(ClassLoader parentClassLoader, List<MuleModule> muleModules, ClassLoaderLookupPolicy containerLookupPolicy, ArtifactDescriptor artifactDescriptor) {
        return this.createContainerFilteringClassLoader(parentClassLoader, muleModules, new MuleContainerClassLoader(artifactDescriptor, new URL[0], parentClassLoader, containerLookupPolicy));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Map<String, LookupStrategy> buildClassLoaderLookupStrategy(ClassLoader containerClassLoader, List<MuleModule> modules) {
        Preconditions.checkArgument(containerClassLoader != null, "containerClassLoader cannot be null");
        Preconditions.checkArgument(modules != null, "modules cannot be null");
        containerOnlyLookupStrategy = new ContainerOnlyLookupStrategy(containerClassLoader);
        result = new HashMap<String, LookupStrategy>();
        for (MuleModule muleModule : modules) {
            for (String exportedPackage : muleModule.getExportedPackages()) {
                if (!ContainerClassLoaderFactory.ALLOW_JRE_EXTENSION) ** GOTO lbl-1000
                if (Arrays.stream(ContainerClassLoaderFactory.JRE_EXTENDABLE_PACKAGES).anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, startsWith(java.lang.String ), (Ljava/lang/String;)Z)((String)exportedPackage))) {
                    v0 /* !! */  = ParentFirstLookupStrategy.PARENT_FIRST;
                } else lbl-1000:
                // 2 sources

                {
                    v0 /* !! */  = containerOnlyLookupStrategy;
                }
                result.put(exportedPackage, v0 /* !! */ );
            }
        }
        return result;
    }

    protected FilteringArtifactClassLoader createContainerFilteringClassLoader(ClassLoader parentClassLoader, List<MuleModule> muleModules, ArtifactClassLoader containerClassLoader) {
        return new FilteringContainerClassLoader(parentClassLoader, containerClassLoader, new ContainerClassLoaderFilterFactory().create(this.getBootPackages(), muleModules), this.getExportedServices(muleModules));
    }

    private List<ExportedService> getExportedServices(List<MuleModule> muleModules) {
        ArrayList<ExportedService> exportedServices = new ArrayList<ExportedService>();
        for (MuleModule muleModule : muleModules) {
            exportedServices.addAll(muleModule.getExportedServices());
        }
        return exportedServices;
    }

    protected Set<String> getBootPackages() {
        return BOOT_PACKAGES;
    }

    private static final class MuleContainerClassLoader
    extends MuleArtifactClassLoader {
        private MuleContainerClassLoader(ArtifactDescriptor artifactDescriptor, URL[] urls, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy) {
            super("container", artifactDescriptor, urls, parent, lookupPolicy);
        }

        @Override
        public URL findResource(String name) {
            return null;
        }

        @Override
        public Enumeration<URL> findResources(String name) throws IOException {
            return new EnumerationAdapter<URL>(Collections.emptyList());
        }

        static {
            MuleContainerClassLoader.registerAsParallelCapable();
        }
    }
}

