/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import java.io.IOException;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.core.internal.streaming.CursorProviderJanitor;

class ManagedCursorDecorator
extends CursorStream {
    private final CursorStream delegate;
    private final CursorProviderJanitor janitor;

    ManagedCursorDecorator(CursorStream delegate, CursorProviderJanitor janitor) {
        this.delegate = delegate;
        this.janitor = janitor;
    }

    @Override
    public void close() throws IOException {
        try {
            this.delegate.close();
        }
        finally {
            this.janitor.releaseCursor(this.delegate);
        }
    }

    @Override
    public long getPosition() {
        return this.delegate.getPosition();
    }

    @Override
    public void seek(long position) throws IOException {
        this.delegate.seek(position);
    }

    @Override
    public boolean isReleased() {
        return this.delegate.isReleased();
    }

    @Override
    public void release() {
        this.delegate.release();
    }

    @Override
    public CursorProvider getProvider() {
        return this.delegate.getProvider();
    }

    @Override
    public int read() throws IOException {
        return this.delegate.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.delegate.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.delegate.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }
}

