/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.mule.runtime.core.api.util.func.CheckedRunnable;

public class FunctionalUtils {
    public static void safely(CheckedRunnable task) {
        FunctionalUtils.safely(task, e -> {});
    }

    public static void safely(CheckedRunnable task, Consumer<Exception> exceptionHandler) {
        try {
            task.run();
        }
        catch (Exception e) {
            exceptionHandler.accept(e);
        }
    }

    public static <T> Optional<T> or(Optional<T> optional, Supplier<Optional<T>> orElse) {
        return optional.isPresent() ? optional : orElse.get();
    }

    public static <T> void ifPresent(Optional<T> optional, Consumer<? super T> ifPresent, Runnable orElse) {
        if (optional.isPresent()) {
            ifPresent.accept(optional.get());
        } else {
            orElse.run();
        }
    }
}

