/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.client;

import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.client.OperationParameters;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.extension.internal.runtime.client.strategy.ExtensionsClientProcessorsStrategy;
import org.mule.runtime.module.extension.internal.runtime.client.strategy.ExtensionsClientProcessorsStrategyFactory;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import reactor.core.publisher.Mono;

public final class DefaultExtensionsClient
implements ExtensionsClient,
Initialisable {
    @Inject
    private ExtensionsClientProcessorsStrategyFactory extensionsClientProcessorsStrategyFactory;
    private final CoreEvent event;
    private ExtensionsClientProcessorsStrategy extensionsClientProcessorsStrategy;

    public DefaultExtensionsClient(CoreEvent event, ExtensionsClientProcessorsStrategyFactory extensionsClientProcessorsStrategyFactory) {
        this.event = event;
        this.extensionsClientProcessorsStrategyFactory = extensionsClientProcessorsStrategyFactory;
    }

    public DefaultExtensionsClient() {
        this.event = null;
    }

    @Override
    public <T, A> CompletableFuture<Result<T, A>> executeAsync(String extension, String operation, OperationParameters parameters) {
        OperationMessageProcessor processor = this.extensionsClientProcessorsStrategy.getOperationMessageProcessor(extension, operation, parameters);
        return Mono.just(this.extensionsClientProcessorsStrategy.getEvent(parameters)).transform(processor).map(event -> Result.builder(event.getMessage()).build()).onErrorMap(Exceptions::unwrap).doAfterTerminate(() -> this.extensionsClientProcessorsStrategy.disposeProcessor(processor)).toFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, A> Result<T, A> execute(String extension, String operation, OperationParameters params) throws MuleException {
        OperationMessageProcessor processor = this.extensionsClientProcessorsStrategy.getOperationMessageProcessor(extension, operation, params);
        try {
            CoreEvent process = processor.process(this.extensionsClientProcessorsStrategy.getEvent(params));
            Result result = Result.builder(process.getMessage()).build();
            return result;
        }
        finally {
            this.extensionsClientProcessorsStrategy.disposeProcessor(processor);
        }
    }

    @Override
    public void initialise() throws InitialisationException {
        this.extensionsClientProcessorsStrategy = this.extensionsClientProcessorsStrategyFactory.create(this.event);
    }
}

