/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.client.strategy;

import com.github.benmanes.caffeine.cache.Cache;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.extension.api.client.OperationParameters;
import org.mule.runtime.module.extension.internal.runtime.client.strategy.AbstractExtensionsClientProcessorsStrategy;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public class CachedExtensionsClientProcessorsStrategy
extends AbstractExtensionsClientProcessorsStrategy {
    private static String INTERNAL_VARIABLE_PREFIX = "INTERNAL_VARIABLE_";
    private Cache<String, OperationMessageProcessor> operationMessageProcessorCache;

    public CachedExtensionsClientProcessorsStrategy(ExtensionManager extensionManager, Registry registry, MuleContext muleContext, PolicyManager policyManager, ReflectionCache reflectionCache, CoreEvent event, Cache<String, OperationMessageProcessor> operationMessageProcessorCache) {
        super(extensionManager, registry, muleContext, policyManager, reflectionCache, event);
        this.operationMessageProcessorCache = operationMessageProcessorCache;
    }

    @Override
    public OperationMessageProcessor getOperationMessageProcessor(String extensionName, String operationName, OperationParameters parameters) {
        String key = this.buildKey(extensionName, operationName, parameters);
        return (OperationMessageProcessor)this.operationMessageProcessorCache.get((Object)key, cacheKey -> {
            Map<String, ValueResolver> params = parameters.get().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> {
                ExpressionValueResolver resolver = new ExpressionValueResolver("#[vars." + INTERNAL_VARIABLE_PREFIX + (String)e.getKey() + "]");
                try {
                    LifecycleUtils.initialiseIfNeeded(resolver, true, this.muleContext);
                }
                catch (InitialisationException ex) {
                    throw new MuleRuntimeException(ex);
                }
                return resolver;
            }));
            return this.createProcessor(extensionName, operationName, parameters.getConfigName(), params);
        });
    }

    @Override
    public CoreEvent getEvent(OperationParameters parameters) {
        return this.event == null ? this.buildChildEvent(this.getBaseEvent(), parameters) : this.buildChildEvent(this.event, parameters);
    }

    @Override
    public void disposeProcessor(OperationMessageProcessor operationMessageProcessor) {
    }

    private CoreEvent buildChildEvent(CoreEvent event, OperationParameters parameters) {
        CoreEvent.Builder childEventBuilder = CoreEvent.builder(event);
        Map<String, ValueResolver> operationParameters = this.resolveParameters(parameters.get(), event);
        for (String key : operationParameters.keySet()) {
            ValueResolver valueResolver = operationParameters.get(key);
            try {
                Object value = valueResolver.resolve(ValueResolvingContext.from(event));
                childEventBuilder.addVariable(INTERNAL_VARIABLE_PREFIX + key, value, DataType.fromObject(value));
            }
            catch (MuleException e) {
                throw new MuleRuntimeException(e);
            }
        }
        return childEventBuilder.build();
    }

    private String buildKey(String extension, String operation, OperationParameters parameters) {
        char separator = '&';
        StringBuilder keyBuilder = new StringBuilder(256);
        keyBuilder.append(extension).append(separator).append(operation).append(separator).append(parameters.getConfigName().orElse(""));
        List keyList = parameters.get().keySet().stream().collect(Collectors.toList());
        Collections.sort(keyList, Comparator.naturalOrder());
        for (String key : keyList) {
            keyBuilder.append(separator).append(key);
        }
        return keyBuilder.toString();
    }
}

