/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.lang.reflect.Method;
import java.util.Map;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutorFactory;
import org.mule.runtime.module.extension.internal.runtime.execution.ReflectiveExecutorFactoryUtil;
import org.mule.runtime.module.extension.internal.runtime.operation.ReflectiveMethodOperationExecutor;

public final class ReflectiveOperationExecutorFactory<T, M extends ComponentModel>
implements ComponentExecutorFactory<M> {
    private final Class<T> implementationClass;
    private final Method operationMethod;

    public ReflectiveOperationExecutorFactory(Class<T> implementationClass, Method operationMethod) {
        Preconditions.checkArgument(implementationClass != null, "implementationClass cannot be null");
        Preconditions.checkArgument(operationMethod != null, "operationMethod cannot be null");
        this.implementationClass = implementationClass;
        this.operationMethod = operationMethod;
    }

    @Override
    public ComponentExecutor<M> createExecutor(M operationModel, Map<String, Object> parameters) {
        return new ReflectiveMethodOperationExecutor<M>(operationModel, this.operationMethod, ReflectiveExecutorFactoryUtil.createDelegate(this.implementationClass, parameters));
    }
}

