/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.util;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Types;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.util.collection.Collectors;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Ignore;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.declaration.type.annotation.LiteralTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ParameterResolverTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.TypedValueTypeAnnotation;
import org.mule.runtime.extension.api.exception.IllegalConfigurationModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.parameter.Literal;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.internal.property.TargetModelProperty;
import org.mule.runtime.module.extension.api.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.PropertyElement;
import org.mule.runtime.module.extension.api.loader.java.type.TypeGeneric;
import org.mule.runtime.module.extension.internal.loader.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.DefaultEncodingModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingParameterModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.InjectedFieldModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.RequireNameField;
import org.mule.runtime.module.extension.internal.util.FieldSetter;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.reflections.ReflectionUtils;
import org.springframework.core.ResolvableType;

public final class IntrospectionUtils {
    private IntrospectionUtils() {
    }

    public static MetadataType getMetadataType(Class<?> type, ClassTypeLoader typeLoader) {
        return typeLoader.load(ResolvableType.forClass(type).getType());
    }

    public static DataType toDataType(MetadataType metadataType) {
        final Class type = ExtensionMetadataTypeUtils.getType(metadataType).orElse(null);
        if (type == null) {
            return DataType.fromType(Object.class);
        }
        final Reference dataType = new Reference();
        metadataType.accept(new MetadataTypeVisitor(){

            @Override
            protected void defaultVisit(MetadataType metadataType) {
                dataType.set(DataType.fromType(type));
            }

            @Override
            public void visitArrayType(ArrayType arrayType) {
                java.util.Optional optionalItemClass = ExtensionMetadataTypeUtils.getType(arrayType.getType());
                if (optionalItemClass.isPresent()) {
                    Class itemClass = optionalItemClass.get();
                    if (Collection.class.isAssignableFrom(type)) {
                        dataType.set(DataType.builder().collectionType(type).itemType(itemClass).build());
                    } else if (Iterator.class.isAssignableFrom(type)) {
                        dataType.set(DataType.builder().streamType(type).itemType(itemClass).build());
                    } else {
                        this.defaultVisit(arrayType);
                    }
                } else {
                    this.defaultVisit(arrayType);
                }
            }

            @Override
            public void visitObject(ObjectType objectType) {
                if (Map.class.isAssignableFrom(type)) {
                    dataType.set(DataType.builder().mapType(type).keyType(String.class).valueType(objectType.getOpenRestriction().map(restriction -> {
                        if (restriction.getAnnotation(TypedValueTypeAnnotation.class).isPresent()) {
                            return TypedValue.class;
                        }
                        return ExtensionMetadataTypeUtils.getType(restriction).get();
                    }).orElse(Object.class)).build());
                } else {
                    this.defaultVisit(objectType);
                }
            }
        });
        return (DataType)dataType.get();
    }

    public static MetadataType getMethodReturnType(MethodElement method) {
        Preconditions.checkArgument(method != null, "Can't introspect a null method");
        return IntrospectionUtils.getReturnType(method.getReturnType());
    }

    public static MetadataType getSourceReturnType(org.mule.runtime.module.extension.api.loader.java.type.Type returnType) {
        return IntrospectionUtils.getReturnType(returnType);
    }

    private static MetadataType getReturnType(org.mule.runtime.module.extension.api.loader.java.type.Type returnType) {
        org.mule.runtime.module.extension.api.loader.java.type.Type itemType;
        org.mule.runtime.module.extension.api.loader.java.type.Type type = returnType;
        if (returnType.isAssignableTo(Result.class)) {
            List<TypeGeneric> generics = returnType.getGenerics();
            if (generics.isEmpty()) {
                return IntrospectionUtils.typeBuilder().anyType().build();
            }
            org.mule.runtime.module.extension.api.loader.java.type.Type payloadType = generics.get(0).getConcreteType();
            type = !payloadType.isAnyType() ? payloadType : null;
        }
        if (IntrospectionUtils.isPagingProvider(returnType)) {
            itemType = IntrospectionUtils.getPagingProviderTypes(returnType).getSecond();
            if (itemType.isSameType(Result.class)) {
                return IntrospectionUtils.returnListOfMessagesType(returnType, itemType);
            }
            return IntrospectionUtils.typeBuilder().arrayType().of(itemType.asMetadataType()).with(returnType.getClassInformation()).build();
        }
        if (returnType.isAssignableTo(ParameterResolver.class) || returnType.isAssignableTo(TypedValue.class) || returnType.isAssignableTo(Literal.class)) {
            type = returnType.getGenerics().get(0).getConcreteType();
        }
        if (IntrospectionUtils.isCollection(returnType) && !returnType.getGenerics().isEmpty() && (itemType = returnType.getGenerics().get(0).getConcreteType()).isAssignableTo(Result.class)) {
            return IntrospectionUtils.returnListOfMessagesType(returnType, itemType);
        }
        return type != null ? type.asMetadataType() : IntrospectionUtils.typeBuilder().anyType().build();
    }

    private static MetadataType returnListOfMessagesType(org.mule.runtime.module.extension.api.loader.java.type.Type returnType, org.mule.runtime.module.extension.api.loader.java.type.Type resultType) {
        MetadataType outputType;
        if (resultType.getGenerics().isEmpty()) {
            AnyType anyType = IntrospectionUtils.typeBuilder().anyType().build();
            return IntrospectionUtils.getListOfMessageType(returnType, anyType, anyType);
        }
        TypeGeneric genericType = resultType.getGenerics().get(0);
        org.mule.runtime.module.extension.api.loader.java.type.Type payloadType = genericType.getConcreteType();
        if (payloadType.isAnyType()) {
            outputType = IntrospectionUtils.typeBuilder().anyType().build();
        } else {
            if (payloadType.isAssignableTo(TypedValue.class)) {
                payloadType = payloadType.getGenerics().get(0).getConcreteType();
            }
            outputType = payloadType.asMetadataType();
        }
        org.mule.runtime.module.extension.api.loader.java.type.Type attributesType = resultType.getGenerics().get(1).getConcreteType();
        MetadataType attributesOutputType = attributesType.isAnyType() ? IntrospectionUtils.typeBuilder().anyType().build() : attributesType.asMetadataType();
        return IntrospectionUtils.getListOfMessageType(returnType, outputType, attributesOutputType);
    }

    private static ArrayType getListOfMessageType(org.mule.runtime.module.extension.api.loader.java.type.Type returnType, MetadataType outputType, MetadataType attributesOutputType) {
        return IntrospectionUtils.typeBuilder().arrayType().of(new MessageMetadataTypeBuilder().payload(outputType).attributes(attributesOutputType).build()).with(returnType.getClassInformation()).build();
    }

    private static boolean isCollection(org.mule.runtime.module.extension.api.loader.java.type.Type type) {
        return type.isAssignableTo(Collection.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MetadataType getMethodReturnAttributesType(MethodElement method) {
        org.mule.runtime.module.extension.api.loader.java.type.Type second;
        org.mule.runtime.module.extension.api.loader.java.type.Type genericType;
        List<TypeGeneric> generics;
        org.mule.runtime.module.extension.api.loader.java.type.Type returnType = method.getReturnType();
        org.mule.runtime.module.extension.api.loader.java.type.Type attributesType = null;
        if (returnType.isAssignableTo(Result.class)) {
            generics = returnType.getGenerics();
            if (generics.size() != 2) return IntrospectionUtils.typeBuilder().anyType().build();
            genericType = generics.get(1).getConcreteType();
            if (genericType == null) return IntrospectionUtils.typeBuilder().anyType().build();
            if (genericType.isAnyType()) {
                return IntrospectionUtils.typeBuilder().anyType().build();
            }
            attributesType = genericType;
        }
        if (IntrospectionUtils.isPagingProvider(returnType) && (second = IntrospectionUtils.getPagingProviderTypes(returnType).getSecond()).isSameType(Result.class)) {
            attributesType = null;
        }
        if (!IntrospectionUtils.isCollection(returnType) || (generics = returnType.getGenerics()).size() <= 0 || !(genericType = generics.get(0).getConcreteType()).isAssignableTo(Result.class)) return attributesType != null ? attributesType.asMetadataType() : IntrospectionUtils.typeBuilder().voidType().build();
        attributesType = null;
        return attributesType != null ? attributesType.asMetadataType() : IntrospectionUtils.typeBuilder().voidType().build();
    }

    public static List<MetadataType> getGenerics(Type type, ClassTypeLoader typeLoader) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] generics = parameterizedType.getActualTypeArguments();
            return Stream.of(generics).map(typeLoader::load).collect(java.util.stream.Collectors.toList());
        }
        return new LinkedList<MetadataType>();
    }

    public static boolean isLifecycle(Class<?> type) {
        return Initialisable.class.isAssignableFrom(type) || Startable.class.isAssignableFrom(type) || Stoppable.class.isAssignableFrom(type) || Disposable.class.isAssignableFrom(type);
    }

    public static boolean isLifecycle(org.mule.runtime.module.extension.api.loader.java.type.Type type) {
        return type.isAssignableTo(Initialisable.class) || type.isAssignableTo(Startable.class) || type.isAssignableTo(Stoppable.class) || type.isAssignableTo(Disposable.class);
    }

    public static boolean isPagingProvider(org.mule.runtime.module.extension.api.loader.java.type.Type type) {
        return type.isAssignableTo(PagingProvider.class);
    }

    private static BaseTypeBuilder typeBuilder() {
        return BaseTypeBuilder.create(MetadataFormat.JAVA);
    }

    public static MetadataType[] getMethodArgumentTypes(Method method, ClassTypeLoader typeLoader) {
        Preconditions.checkArgument(method != null, "Can't introspect a null method");
        Object[] parameters = method.getParameterTypes();
        if (ArrayUtils.isEmpty((Object[])parameters)) {
            return new MetadataType[0];
        }
        MetadataType[] types = new MetadataType[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            ResolvableType type = ResolvableType.forMethodParameter((Method)method, (int)i);
            types[i] = typeLoader.load(type.getType());
        }
        return types;
    }

    public static MetadataType getFieldMetadataType(Field field, ClassTypeLoader typeLoader) {
        Preconditions.checkArgument(field != null, "Can't introspect a null field");
        return typeLoader.load(ResolvableType.forField((Field)field).getType());
    }

    public static java.util.Optional<Field> getFieldByNameOrAlias(Class<?> clazz, String nameOrAlias, ReflectionCache reflectionCache) {
        java.util.Optional<Field> field = IntrospectionUtils.getField(clazz, nameOrAlias, reflectionCache);
        if (!field.isPresent()) {
            field = ReflectionUtils.getAllFields(clazz, (Predicate[])new Predicate[]{f -> IntrospectionUtils.getAlias(f).equals(nameOrAlias)}).stream().findFirst();
        }
        return field;
    }

    public static java.util.Optional<Field> getField(Class<?> clazz, ParameterModel parameterModel, ReflectionCache reflectionCache) {
        return IntrospectionUtils.getField(clazz, IntrospectionUtils.getMemberName(parameterModel, parameterModel.getName()), reflectionCache);
    }

    public static java.util.Optional<Field> getField(Class<?> clazz, ParameterDeclaration parameterDeclaration, ReflectionCache reflectionCache) {
        return IntrospectionUtils.getField(clazz, MuleExtensionAnnotationParser.getMemberName(parameterDeclaration, parameterDeclaration.getName()), reflectionCache);
    }

    public static java.util.Optional<Field> getField(Class<?> clazz, String name, ReflectionCache reflectionCache) {
        return reflectionCache.getFields(clazz).stream().filter(f -> f.getName().equals(name)).findFirst();
    }

    public static Object getFieldValue(Object object, String fieldName, ReflectionCache reflectionCache) throws IllegalAccessException, NoSuchFieldException {
        java.util.Optional<Field> fieldOptional = IntrospectionUtils.getField(object.getClass(), fieldName, reflectionCache);
        if (fieldOptional.isPresent()) {
            Field field = fieldOptional.get();
            field.setAccessible(true);
            return field.get(object);
        }
        throw new NoSuchFieldException();
    }

    public static <T extends EnrichableModel & NamedObject> String getMemberName(T enrichableNamedModel) {
        return IntrospectionUtils.getMemberName(enrichableNamedModel, ((NamedObject)enrichableNamedModel).getName());
    }

    public static String getMemberName(EnrichableModel enrichableModel, String defaultName) {
        return enrichableModel.getModelProperty(DeclaringMemberModelProperty.class).map(p -> p.getDeclaringField().getName()).orElse(defaultName);
    }

    public static java.util.Optional<Field> getMemberField(EnrichableModel enrichableModel) {
        return enrichableModel.getModelProperty(DeclaringMemberModelProperty.class).map(p -> p.getDeclaringField());
    }

    public static List<TypeMirror> getInterfaceGenerics(TypeMirror type, TypeElement implementedInterface, ProcessingEnvironment processingEnvironment) {
        TypeMirror typeMirror;
        Element element;
        TypeMirror searchType;
        TypeMirror erasure;
        Types types = processingEnvironment.getTypeUtils();
        if (types.isSameType(erasure = types.erasure(implementedInterface.asType()), searchType = types.erasure(type)) && type instanceof DeclaredType) {
            return ((DeclaredType)type).getTypeArguments();
        }
        for (TypeMirror typeMirror2 : ((TypeElement)types.asElement(type)).getInterfaces()) {
            if (!types.isAssignable(types.erasure(typeMirror2), erasure)) continue;
            ArrayList<TypeMirror> generics = new ArrayList<TypeMirror>();
            List<? extends TypeMirror> typeArguments = ((DeclaredType)typeMirror2).getTypeArguments();
            for (TypeMirror typeMirror3 : typeArguments) {
                if (typeMirror3 instanceof DeclaredType) {
                    generics.add(typeMirror3);
                    continue;
                }
                if (!(typeMirror3 instanceof TypeVariable)) continue;
                DeclaredType declaredType = (DeclaredType)((DeclaredType)type).asElement().asType();
                List<? extends TypeMirror> typeTypeArguments = declaredType.getTypeArguments();
                int i = typeTypeArguments.indexOf(typeMirror3);
                generics.add(((DeclaredType)type).getTypeArguments().get(i));
            }
            return generics;
        }
        if (type instanceof DeclaredType && (element = ((DeclaredType)type).asElement()) instanceof TypeElement && types.isAssignable(types.erasure(typeMirror = ((TypeElement)element).getSuperclass()), erasure)) {
            return IntrospectionUtils.getInterfaceGenerics(typeMirror, implementedInterface, processingEnvironment);
        }
        return Collections.emptyList();
    }

    public static List<ResolvableType> getInterfaceGenerics(Type type, Class<?> implementedInterface) {
        ResolvableType interfaceType = null;
        ResolvableType searchClass = ResolvableType.forType((Type)type);
        if (searchClass.getRawClass().equals(implementedInterface)) {
            return Arrays.asList(ResolvableType.forType((Type)type).getGenerics());
        }
        while (!Object.class.equals((Object)searchClass.getRawClass())) {
            for (ResolvableType iType : searchClass.getInterfaces()) {
                if (!implementedInterface.isAssignableFrom(iType.getRawClass())) continue;
                interfaceType = iType;
                break;
            }
            if (interfaceType != null) break;
            searchClass = searchClass.getSuperType();
        }
        if (interfaceType == null) {
            throw new IllegalArgumentException(String.format("Class '%s' does not implement the '%s' interface", type.getTypeName(), implementedInterface.getName()));
        }
        List<ResolvableType> generics = Arrays.asList(interfaceType.getGenerics());
        if (generics.stream().anyMatch(obj -> Objects.isNull(obj.getRawClass()))) {
            return IntrospectionUtils.findGenericsInSuperHierarchy(ResolvableType.forType((Type)type).getRawClass()).stream().map(ResolvableType::forClass).collect(java.util.stream.Collectors.toList());
        }
        return generics;
    }

    public static List<Class<?>> findGenericsInSuperHierarchy(Class<?> type) {
        if (Object.class.equals(type)) {
            return ImmutableList.of();
        }
        Class<?> superClass = type.getSuperclass();
        List<Type> generics = IntrospectionUtils.getSuperClassGenerics(type, superClass);
        if (CollectionUtils.isEmpty(generics) && !Object.class.equals(superClass)) {
            return IntrospectionUtils.findGenericsInSuperHierarchy(superClass);
        }
        return generics;
    }

    public static List<TypeMirror> getSuperClassGenerics(TypeElement type, Class superClass, ProcessingEnvironment processingEnvironment) {
        TypeElement superClassTypeElement = processingEnvironment.getElementUtils().getTypeElement(superClass.getName());
        TypeElement objectType = processingEnvironment.getElementUtils().getTypeElement(Object.class.getName());
        TypeMirror superClassTypeMirror = processingEnvironment.getTypeUtils().erasure(superClassTypeElement.asType());
        if (!processingEnvironment.getTypeUtils().isAssignable(type.asType(), superClassTypeMirror)) {
            throw new IllegalArgumentException(String.format("Class '%s' does not extend the '%s' class", type.getQualifiedName(), superClass.getSimpleName()));
        }
        DeclaredType searchClass = (DeclaredType)type.asType();
        while (!processingEnvironment.getTypeUtils().isAssignable(objectType.asType(), searchClass)) {
            if (processingEnvironment.getTypeUtils().isSameType(superClassTypeMirror, processingEnvironment.getTypeUtils().erasure(searchClass))) {
                List<TypeMirror> typeArguments = searchClass.getTypeArguments();
                return typeArguments;
            }
            TypeMirror superclass = ((TypeElement)searchClass.asElement()).getSuperclass();
            if (superclass instanceof DeclaredType) {
                searchClass = (DeclaredType)superclass;
                continue;
            }
            searchClass = (DeclaredType)objectType.asType();
        }
        return Collections.emptyList();
    }

    public static List<Type> getSuperClassGenerics(Class<?> type, Class<?> superClass) {
        if (!superClass.isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format("Class '%s' does not extend the '%s' class", type.getName(), superClass.getName()));
        }
        ResolvableType searchType = ResolvableType.forType(type);
        while (!Object.class.equals((Object)searchType.getType())) {
            ResolvableType[] generics = searchType.getGenerics();
            if (generics.length > 0) {
                return Arrays.stream(generics).map(g -> g.getType()).collect(java.util.stream.Collectors.toList());
            }
            if (superClass.equals(searchType.getType())) break;
            searchType = searchType.getSuperType();
        }
        return new LinkedList<Type>();
    }

    public static void checkInstantiable(Class<?> declaringClass, ReflectionCache reflectionCache) {
        IntrospectionUtils.checkInstantiable(declaringClass, true, reflectionCache);
    }

    public static void checkInstantiable(Class<?> declaringClass, boolean requireDefaultConstructor, ReflectionCache reflectionCache) {
        if (!IntrospectionUtils.isInstantiable(declaringClass, requireDefaultConstructor, reflectionCache)) {
            throw new IllegalArgumentException(String.format("Class %s cannot be instantiated.", declaringClass));
        }
    }

    public static boolean isInstantiable(MetadataType type, ReflectionCache reflectionCache) {
        return type.getAnnotation(ClassInformationAnnotation.class).map(ClassInformationAnnotation::isInstantiable).orElseGet(() -> ExtensionMetadataTypeUtils.getType(type).map(t -> IntrospectionUtils.isInstantiable(t, reflectionCache)).orElse(false));
    }

    public static boolean isInstantiable(Class<?> declaringClass, ReflectionCache reflectionCache) {
        return IntrospectionUtils.isInstantiable(declaringClass, true, reflectionCache);
    }

    public static boolean isInstantiable(Class<?> declaringClass, boolean requireDefaultConstructor, ReflectionCache reflectionCache) {
        return declaringClass != null && (!requireDefaultConstructor || reflectionCache.hasDefaultConstructor(declaringClass)) && !declaringClass.isInterface() && !Modifier.isAbstract(declaringClass.getModifiers());
    }

    public static boolean assignableFromAny(Class<?> type, Collection<Class<?>> matchingTypes) {
        return matchingTypes.stream().anyMatch(t -> t.isAssignableFrom(type));
    }

    public static boolean isRequired(AccessibleObject object) {
        return object.getAnnotation(Optional.class) == null;
    }

    public static boolean isRequired(ParameterModel parameterModel, boolean forceOptional) {
        return !forceOptional && parameterModel.isRequired();
    }

    public static boolean isVoid(Method method) {
        return IntrospectionUtils.isVoid(method.getReturnType());
    }

    public static boolean isVoid(ComponentModel componentModel) {
        return componentModel instanceof HasOutputModel && ((HasOutputModel)((Object)componentModel)).getOutput().getType() instanceof VoidType;
    }

    private static boolean isVoid(Class<?> type) {
        return type.equals(Void.TYPE) || type.equals(Void.class);
    }

    public static boolean isVoid(MethodElement methodElement) {
        org.mule.runtime.module.extension.api.loader.java.type.Type returnTypeElement = methodElement.getReturnType();
        return returnTypeElement.isAssignableFrom(Void.TYPE) || returnTypeElement.isAssignableFrom(Void.class);
    }

    public static Collection<Method> getApiMethods(Class<?> declaringClass) {
        return IntrospectionUtils.getMethodsStream(declaringClass).filter(method -> !method.isAnnotationPresent(Ignore.class) && !IntrospectionUtils.isLifecycleMethod(method)).collect(java.util.stream.Collectors.toCollection(LinkedHashSet::new));
    }

    public static Collection<ExecutableElement> getApiMethods(TypeElement typeElement, ProcessingEnvironment processingEnvironment) {
        return IntrospectionUtils.getMethodsStream(typeElement, true, processingEnvironment).filter(method -> method.getAnnotation(Ignore.class) == null && !IntrospectionUtils.isLifecycleMethod(method, processingEnvironment)).collect(java.util.stream.Collectors.toCollection(LinkedHashSet::new));
    }

    private static boolean isLifecycleMethod(Method method) {
        return IntrospectionUtils.isLifecycleMethod(method, Initialisable.class, "initialise") || IntrospectionUtils.isLifecycleMethod(method, Startable.class, "start") || IntrospectionUtils.isLifecycleMethod(method, Stoppable.class, "stop") || IntrospectionUtils.isLifecycleMethod(method, Disposable.class, "dispose");
    }

    private static boolean isLifecycleMethod(ExecutableElement method, ProcessingEnvironment processingEnvironment) {
        return IntrospectionUtils.isLifecycleMethod(method, Initialisable.class, "initialise", processingEnvironment) || IntrospectionUtils.isLifecycleMethod(method, Startable.class, "start", processingEnvironment) || IntrospectionUtils.isLifecycleMethod(method, Stoppable.class, "stop", processingEnvironment) || IntrospectionUtils.isLifecycleMethod(method, Disposable.class, "dispose", processingEnvironment);
    }

    private static boolean isLifecycleMethod(Method method, Class<?> lifecycleClass, String lifecycleMethodName) {
        return lifecycleClass.isAssignableFrom(method.getDeclaringClass()) && method.getName().equals(lifecycleMethodName);
    }

    private static boolean isLifecycleMethod(ExecutableElement method, Class<?> lifecycleClass, String lifecycleMethodName, ProcessingEnvironment processingEnvironment) {
        TypeElement lifecycleElement = processingEnvironment.getElementUtils().getTypeElement(lifecycleClass.getTypeName());
        return processingEnvironment.getTypeUtils().isAssignable(method.getEnclosingElement().asType(), lifecycleElement.asType()) && method.getSimpleName().toString().equals(lifecycleMethodName);
    }

    public static Collection<Method> getMethodsAnnotatedWith(Class<?> declaringClass, Class<? extends Annotation> annotationType) {
        return IntrospectionUtils.getMethodsAnnotatedWith(declaringClass, annotationType, true);
    }

    public static Collection<Method> getMethodsAnnotatedWith(Class<?> declaringClass, Class<? extends Annotation> annotationType, boolean superClasses) {
        return IntrospectionUtils.getMethodsStream(declaringClass, superClasses).filter(method -> method.getAnnotation(annotationType) != null).collect(java.util.stream.Collectors.toCollection(LinkedHashSet::new));
    }

    private static Stream<Method> getMethodsStream(Class<?> declaringClass) {
        return IntrospectionUtils.getMethodsStream(declaringClass, true);
    }

    private static Stream<Method> getMethodsStream(Class<?> declaringClass, boolean superClasses) {
        Stream<Method> methodStream = superClasses ? ReflectionUtils.getAllSuperTypes(declaringClass, (Predicate[])new Predicate[0]).stream().filter(type -> !type.isInterface()).flatMap(type -> Stream.of(type.getDeclaredMethods())) : Stream.of(declaringClass.getDeclaredMethods());
        return methodStream.filter(method -> Modifier.isPublic(method.getModifiers()));
    }

    private static Stream<ExecutableElement> getMethodsStream(TypeElement typeElement, boolean superClasses, ProcessingEnvironment processingEnvironment) {
        Stream<Object> methodStream = superClasses ? IntrospectionUtils.getAllSuperTypes(typeElement, processingEnvironment).stream().flatMap(type -> IntrospectionUtils.getEnclosingMethods(type).stream()) : IntrospectionUtils.getEnclosingMethods(typeElement).stream();
        return methodStream.filter(method -> method.getModifiers().contains((Object)javax.lang.model.element.Modifier.PUBLIC));
    }

    private static Set<ExecutableElement> getEnclosingMethods(TypeElement typeElement) {
        return typeElement.getEnclosedElements().stream().filter(elem -> elem.getKind().equals((Object)ElementKind.METHOD)).map(elem -> (ExecutableElement)elem).collect(java.util.stream.Collectors.toSet());
    }

    private static List<TypeElement> getAllSuperTypes(TypeElement typeElement, ProcessingEnvironment processingEnvironment) {
        TypeElement objectType = processingEnvironment.getElementUtils().getTypeElement(Object.class.getTypeName());
        LinkedList<TypeElement> typeElements = new LinkedList<TypeElement>();
        TypeElement currentType = typeElement;
        while (currentType != null && !objectType.equals(currentType)) {
            typeElements.addFirst(currentType);
            currentType = (TypeElement)processingEnvironment.getTypeUtils().asElement(currentType.getSuperclass());
        }
        return typeElements;
    }

    public static List<Field> getAnnotatedFields(Class<?> clazz, Class<? extends Annotation> annotationType) {
        return IntrospectionUtils.getDescendingHierarchy(clazz).stream().flatMap(type -> Arrays.stream(type.getDeclaredFields())).filter(field -> field.getAnnotation(annotationType) != null).collect(Collectors.toImmutableList());
    }

    public static List<Field> getFields(Class<?> clazz) {
        try {
            return IntrospectionUtils.getFieldsStream(clazz).collect(Collectors.toImmutableList());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static List<VariableElement> getFields(TypeElement typeElement, ProcessingEnvironment processingEnvironment) {
        try {
            return IntrospectionUtils.getFieldsStream(typeElement, processingEnvironment).collect(Collectors.toImmutableList());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static Stream<VariableElement> getFieldsStream(TypeElement typeElement, ProcessingEnvironment processingEnvironment) {
        try {
            return IntrospectionUtils.getAllSuperTypes(typeElement, processingEnvironment).stream().flatMap(elem -> elem.getEnclosedElements().stream()).filter(elem -> elem.getKind() == ElementKind.FIELD).map(varElement -> (VariableElement)varElement);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static Stream<Field> getFieldsStream(Class<?> clazz) {
        try {
            return IntrospectionUtils.getDescendingHierarchy(clazz).stream().flatMap(type -> Arrays.stream(type.getDeclaredFields()));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Field> getFieldsOfType(Class<?> introspectedType, Class fieldType) {
        return IntrospectionUtils.getFieldsStream(introspectedType).filter(f -> fieldType.isAssignableFrom(f.getType()) && !Modifier.isStatic(f.getModifiers())).collect(java.util.stream.Collectors.toList());
    }

    public static <T extends AnnotatedElement & Member> String getAlias(T element) {
        Alias alias = element.getAnnotation(Alias.class);
        return alias != null ? alias.value() : ((Member)element).getName();
    }

    private static List<Class<?>> getDescendingHierarchy(Class<?> type) {
        LinkedList types = new LinkedList();
        types.add(type);
        for (type = type.getSuperclass(); type != null && !Object.class.equals(type); type = type.getSuperclass()) {
            types.add(0, type);
        }
        return ImmutableList.copyOf(types);
    }

    public static Collection<Field> getExposedFields(Class<?> extensionType, ReflectionCache reflectionCache) {
        List<Field> allFields = IntrospectionUtils.getAnnotatedFields(extensionType, org.mule.runtime.extension.api.annotation.param.Parameter.class);
        if (!allFields.isEmpty()) {
            return allFields;
        }
        return IntrospectionUtils.getFieldsWithGetters(extensionType, reflectionCache);
    }

    public static Set<Field> getFieldsWithGetters(Class<?> extensionType, ReflectionCache reflectionCache) {
        return IntrospectionUtils.getPropertyDescriptors(extensionType).stream().filter(p -> p.getReadMethod() != null).map(p -> IntrospectionUtils.getField(extensionType, p.getName(), reflectionCache)).filter(java.util.Optional::isPresent).map(java.util.Optional::get).collect(java.util.stream.Collectors.toSet());
    }

    public static List<FieldElement> getFieldsWithGetters(org.mule.runtime.module.extension.api.loader.java.type.Type extensionType) {
        Set properties = extensionType.getProperties().stream().filter(p -> p.getAccess().equals((Object)PropertyElement.Accessibility.READ_ONLY) || p.getAccess().equals((Object)PropertyElement.Accessibility.READ_WRITE)).map(p -> p.getName()).collect(java.util.stream.Collectors.toSet());
        return extensionType.getFields().stream().filter(field -> properties.contains(field.getName())).collect(java.util.stream.Collectors.toList());
    }

    public static List<PropertyDescriptor> getPropertyDescriptors(Class<?> extensionType) {
        try {
            PropertyDescriptor[] propertyDescriptors = Introspector.getBeanInfo(extensionType).getPropertyDescriptors();
            return Arrays.asList(propertyDescriptors);
        }
        catch (IntrospectionException e) {
            throw new IllegalModelDefinitionException("Could not introspect POJO: " + extensionType.getName(), e);
        }
    }

    public static ExpressionSupport getExpressionSupport(AnnotatedElement object) {
        return IntrospectionUtils.getExpressionSupport(object.getAnnotation(Expression.class));
    }

    public static ExpressionSupport getExpressionSupport(Expression expressionAnnotation) {
        return expressionAnnotation != null ? expressionAnnotation.value() : ExpressionSupport.SUPPORTED;
    }

    public static String getSourceName(Class<? extends Source> sourceType) {
        Alias alias = sourceType.getAnnotation(Alias.class);
        if (alias != null) {
            return alias.value();
        }
        return sourceType.getSimpleName();
    }

    public static <T extends Annotation> T getAnnotation(Class<?> annotatedClass, Class<T> annotationClass) {
        T annotation = annotatedClass.getAnnotation(annotationClass);
        for (Class<?> superClass = annotatedClass.getSuperclass(); annotation == null && superClass != null && !superClass.equals(Object.class); superClass = superClass.getSuperclass()) {
            annotation = superClass.getAnnotation(annotationClass);
        }
        return annotation;
    }

    public static Set<Class<?>> getParameterClasses(ExtensionModel extensionModel, final ClassLoader extensionClassLoader) {
        final HashSet parameterClasses = new HashSet();
        new ExtensionWalker(){

            @Override
            public void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
                parameterClasses.addAll(IntrospectionUtils.collectRelativeClasses(model.getType(), extensionClassLoader));
            }
        }.walk(extensionModel);
        return parameterClasses;
    }

    public static Set<Class<?>> getSubtypeClasses(ExtensionModel extensionModel, ClassLoader extensionClassLoader) {
        return extensionModel.getSubTypes().stream().flatMap(subTypesModel -> {
            HashSet classes = new HashSet();
            classes.addAll(IntrospectionUtils.collectRelativeClasses(subTypesModel.getBaseType(), extensionClassLoader));
            classes.addAll(subTypesModel.getSubTypes().stream().flatMap(type -> IntrospectionUtils.collectRelativeClasses(type, extensionClassLoader).stream()).collect(java.util.stream.Collectors.toSet()));
            return classes.stream();
        }).collect(java.util.stream.Collectors.toSet());
    }

    public static Set<Class<?>> collectRelativeClasses(MetadataType type, final ClassLoader extensionClassLoader) {
        final HashSet relativeClasses = new HashSet();
        type.accept(new MetadataTypeVisitor(){

            @Override
            public void visitArrayType(ArrayType arrayType) {
                arrayType.getType().accept(this);
            }

            @Override
            public void visitObjectField(ObjectFieldType objectFieldType) {
                objectFieldType.getValue().accept(this);
            }

            @Override
            public void visitObject(ObjectType objectType) {
                if (objectType.getMetadataFormat() != MetadataFormat.JAVA) {
                    return;
                }
                Class clazz = ExtensionMetadataTypeUtils.getType(objectType).orElse(null);
                if (clazz == null || relativeClasses.contains(clazz)) {
                    return;
                }
                java.util.Optional<ClassInformationAnnotation> classInformation = objectType.getAnnotation(ClassInformationAnnotation.class);
                if (classInformation.isPresent()) {
                    classInformation.get().getGenericTypes().forEach(generic -> relativeClasses.add(IntrospectionUtils.loadClass(generic, extensionClassLoader)));
                }
                relativeClasses.add(clazz);
                objectType.getFields().stream().forEach(objectFieldType -> objectFieldType.accept(this));
                objectType.getOpenRestriction().ifPresent(t -> t.accept(this));
            }

            @Override
            public void visitString(StringType stringType) {
                if (stringType.getMetadataFormat() == MetadataFormat.JAVA && MetadataTypeUtils.isEnum(stringType)) {
                    ExtensionMetadataTypeUtils.getType(stringType).ifPresent(relativeClasses::add);
                }
            }
        });
        return relativeClasses;
    }

    public static Set<String> collectRelativeClassesAsString(MetadataType type) {
        final HashSet<String> relativeClasses = new HashSet<String>();
        type.accept(new MetadataTypeVisitor(){

            @Override
            public void visitArrayType(ArrayType arrayType) {
                arrayType.getType().accept(this);
            }

            @Override
            public void visitObjectField(ObjectFieldType objectFieldType) {
                objectFieldType.getValue().accept(this);
            }

            @Override
            public void visitObject(ObjectType objectType) {
                if (objectType.getMetadataFormat() != MetadataFormat.JAVA) {
                    return;
                }
                String clazz = JavaTypeUtils.getId(objectType).orElse(null);
                if (clazz == null || relativeClasses.contains(clazz)) {
                    return;
                }
                java.util.Optional<ClassInformationAnnotation> classInformation = objectType.getAnnotation(ClassInformationAnnotation.class);
                classInformation.ifPresent(classInformationAnnotation -> relativeClasses.addAll(classInformationAnnotation.getGenericTypes()));
                relativeClasses.add(clazz);
                objectType.getFields().forEach(objectFieldType -> objectFieldType.accept(this));
                objectType.getOpenRestriction().ifPresent(t -> t.accept(this));
            }

            @Override
            public void visitString(StringType stringType) {
                if (stringType.getMetadataFormat() == MetadataFormat.JAVA && MetadataTypeUtils.isEnum(stringType)) {
                    JavaTypeUtils.getId(stringType).ifPresent(relativeClasses::add);
                }
            }
        });
        return relativeClasses;
    }

    private static Class loadClass(String name, ClassLoader extensionClassloader) {
        try {
            return ClassUtils.loadClass(name, extensionClassloader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean isMultiLevelMetadataKeyId(Set<Class<? extends Annotation>> annotations, MetadataType parameterType) {
        return annotations.contains(MetadataKeyId.class) && MetadataTypeUtils.isObjectType(parameterType);
    }

    public static boolean isParameterContainer(Set<Class<? extends Annotation>> annotations, MetadataType parameterType) {
        return annotations.contains(ParameterGroup.class) || IntrospectionUtils.isMultiLevelMetadataKeyId(annotations, parameterType);
    }

    public static java.util.Optional<AnnotatedElement> getAnnotatedElement(BaseDeclaration<?> declaration) {
        java.util.Optional<DeclaringMemberModelProperty> declaringMember = declaration.getModelProperty(DeclaringMemberModelProperty.class);
        java.util.Optional<ImplementingParameterModelProperty> implementingParameter = declaration.getModelProperty(ImplementingParameterModelProperty.class);
        AnnotatedElement annotatedElement = null;
        if (declaringMember.isPresent()) {
            annotatedElement = declaringMember.get().getDeclaringField();
        }
        if (implementingParameter.isPresent()) {
            annotatedElement = implementingParameter.get().getParameter();
        }
        return java.util.Optional.ofNullable(annotatedElement);
    }

    public static String getContainerName(AnnotatedElement container) {
        if (container instanceof Field) {
            return ((Field)container).getName();
        }
        if (container instanceof Parameter) {
            return ((Parameter)container).getName();
        }
        throw new IllegalArgumentException("Unknown container type");
    }

    public static String getGroupModelContainerName(ParameterGroupModel groupModel) {
        return groupModel.getModelProperty(ParameterGroupModelProperty.class).map(modelProperty -> IntrospectionUtils.getContainerName(modelProperty.getDescriptor().getContainer())).orElse(groupModel.getName());
    }

    public static String getImplementingName(ParameterDeclaration parameterDeclaration) {
        return IntrospectionUtils.getImplementingName(parameterDeclaration.getName(), () -> parameterDeclaration.getModelProperty(ImplementingParameterModelProperty.class), () -> parameterDeclaration.getModelProperty(DeclaringMemberModelProperty.class));
    }

    public static String getImplementingName(ParameterModel parameterModel) {
        return IntrospectionUtils.getImplementingName(parameterModel.getName(), () -> parameterModel.getModelProperty(ImplementingParameterModelProperty.class), () -> parameterModel.getModelProperty(DeclaringMemberModelProperty.class));
    }

    private static String getImplementingName(String originalName, Supplier<java.util.Optional<ImplementingParameterModelProperty>> implementingParameter, Supplier<java.util.Optional<DeclaringMemberModelProperty>> declaringMember) {
        java.util.Optional<ImplementingParameterModelProperty> parameter = implementingParameter.get();
        if (parameter.isPresent()) {
            return parameter.get().getParameter().getName();
        }
        java.util.Optional<DeclaringMemberModelProperty> field = declaringMember.get();
        if (field.isPresent()) {
            return field.get().getDeclaringField().getName();
        }
        return originalName;
    }

    public static boolean isParameterResolver(MetadataType metadataType) {
        return metadataType.getAnnotation(ParameterResolverTypeAnnotation.class).isPresent();
    }

    public static boolean isTargetParameter(Set<ModelProperty> modelProperties) {
        return modelProperties.stream().anyMatch(modelProperty -> modelProperty instanceof TargetModelProperty);
    }

    public static boolean isLiteral(MetadataType metadataType) {
        return metadataType.getAnnotation(LiteralTypeAnnotation.class).isPresent();
    }

    public static boolean isTypedValue(MetadataType metadataType) {
        return metadataType.getAnnotation(TypedValueTypeAnnotation.class).isPresent();
    }

    public static java.util.Optional<ConnectionProviderModel> getConnectionProviderModel(Class<? extends ConnectionProvider> connectionProvider, List<ConnectionProviderModel> allConnectionProviders) {
        for (ConnectionProviderModel providerModel : allConnectionProviders) {
            ImplementingTypeModelProperty property;
            java.util.Optional<ImplementingTypeModelProperty> modelProperty = providerModel.getModelProperty(ImplementingTypeModelProperty.class);
            if (!modelProperty.isPresent() || !(property = modelProperty.get()).getType().equals(connectionProvider)) continue;
            return java.util.Optional.of(providerModel);
        }
        return java.util.Optional.empty();
    }

    private static void injectFieldFromModelProperty(Object target, String value, java.util.Optional<? extends InjectedFieldModelProperty> modelProperty, Class<? extends Annotation> annotationClass) {
        if (value == null || modelProperty == null) {
            return;
        }
        modelProperty.ifPresent(property -> {
            Field field = property.getField();
            if (!field.getDeclaringClass().isInstance(target)) {
                throw new IllegalConfigurationModelDefinitionException(String.format("field '%s' is annotated with @%s but not defined on an instance of type '%s'", field.toString(), annotationClass.getSimpleName(), target.getClass().getName()));
            }
            new FieldSetter<Object, String>(field).set(target, value);
        });
    }

    private static java.util.Optional<FieldSetter> getFieldSetterForAnnotatedField(Object target, Class<? extends Annotation> annotationClass, ReflectionCache reflectionCache) {
        return reflectionCache.getFieldSetterForAnnotatedField(target, annotationClass);
    }

    private static void injectFieldOfType(Object target, Object value, Class<?> fieldType) {
        Class<?> type = target.getClass();
        List<Field> fields = IntrospectionUtils.getFieldsOfType(type, fieldType);
        if (fields.isEmpty()) {
            return;
        }
        if (fields.size() > 1) {
            throw new IllegalModelDefinitionException(String.format("Class '%s' has %d fields of type with @%s. Only one field of that type was expected", type.getName(), fields.size(), fieldType));
        }
        new FieldSetter<Object, Object>(fields.get(0)).set(target, value);
    }

    public static void injectFields(EnrichableModel model, Object target, String configName, String encoding) {
        IntrospectionUtils.injectFieldFromModelProperty(target, configName, model.getModelProperty(RequireNameField.class), RefName.class);
        IntrospectionUtils.injectDefaultEncoding(model, target, encoding);
    }

    public static void injectDefaultEncoding(EnrichableModel model, Object target, String encoding) {
        IntrospectionUtils.injectFieldFromModelProperty(target, encoding, model.getModelProperty(DefaultEncodingModelProperty.class), DefaultEncoding.class);
    }

    public static void injectFields(Object target, String configName, String encoding, ReflectionCache reflectionCache) {
        IntrospectionUtils.injectDefaultEncoding(target, encoding, reflectionCache);
        IntrospectionUtils.set(IntrospectionUtils.getFieldSetterForAnnotatedField(target, RefName.class, reflectionCache), target, configName);
    }

    public static void injectRefName(Object target, String configName, ReflectionCache reflectionCache) {
        IntrospectionUtils.set(IntrospectionUtils.getFieldSetterForAnnotatedField(target, RefName.class, reflectionCache), target, configName);
    }

    public static void injectDefaultEncoding(Object target, String encoding, ReflectionCache reflectionCache) {
        IntrospectionUtils.set(IntrospectionUtils.getDefaultEncodingFieldSetter(target, reflectionCache), target, encoding);
    }

    public static java.util.Optional<FieldSetter> getDefaultEncodingFieldSetter(Object target, ReflectionCache reflectionCache) {
        return IntrospectionUtils.getFieldSetterForAnnotatedField(target, DefaultEncoding.class, reflectionCache);
    }

    public static void injectComponentLocation(Object target, ComponentLocation componentLocation) {
        IntrospectionUtils.injectFieldOfType(target, componentLocation, ComponentLocation.class);
    }

    private static void set(java.util.Optional<FieldSetter> setter, Object target, Object value) {
        setter.ifPresent(s -> s.set(target, value));
    }

    public static Pair<ResolvableType, ResolvableType> getPagingProviderTypes(ResolvableType pagingProvider) {
        if (!PagingProvider.class.isAssignableFrom(pagingProvider.getRawClass())) {
            throw new IllegalArgumentException("The given OutputType is not a PagingProvider");
        }
        ResolvableType[] generics = pagingProvider.getGenerics();
        ResolvableType connectionType = null;
        ResolvableType returnType = null;
        if (generics.length == 0) {
            for (ResolvableType resolvableType : pagingProvider.getInterfaces()) {
                if (!resolvableType.getRawClass().equals(PagingProvider.class)) continue;
                connectionType = resolvableType.getGeneric(new int[]{0});
                returnType = resolvableType.getGeneric(new int[]{1});
            }
        } else {
            connectionType = generics[0];
            returnType = generics[1];
        }
        return new Pair<ResolvableType, ResolvableType>(connectionType, returnType);
    }

    public static Pair<org.mule.runtime.module.extension.api.loader.java.type.Type, org.mule.runtime.module.extension.api.loader.java.type.Type> getPagingProviderTypes(org.mule.runtime.module.extension.api.loader.java.type.Type type) {
        if (!type.isAssignableTo(PagingProvider.class)) {
            throw new IllegalArgumentException("The given OutputType is not a PagingProvider");
        }
        List<org.mule.runtime.module.extension.api.loader.java.type.Type> interfaceGenerics = type.getInterfaceGenerics(PagingProvider.class);
        if (interfaceGenerics.size() == 2) {
            return new Pair<org.mule.runtime.module.extension.api.loader.java.type.Type, org.mule.runtime.module.extension.api.loader.java.type.Type>(interfaceGenerics.get(0), interfaceGenerics.get(1));
        }
        throw new IllegalStateException("PagingProvider must provide their generics");
    }

    public static Map<String, String> getShowInDslParameters(ParameterizedModel parameterizedModel) {
        HashMap<String, String> showInDslMap = new HashMap<String, String>();
        parameterizedModel.getParameterGroupModels().stream().filter(ParameterGroupModel::isShowInDsl).forEach(groupModel -> groupModel.getParameterModels().forEach(param -> showInDslMap.put(IntrospectionUtils.getImplementingName(param), IntrospectionUtils.getGroupModelContainerName(groupModel))));
        return showInDslMap;
    }
}

