/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.event;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ItemSequenceInfo;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.security.SecurityContext;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.message.GroupCorrelation;
import org.mule.runtime.core.api.transformer.MessageTransformerException;
import org.mule.runtime.core.api.util.CaseInsensitiveHashMap;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.core.internal.message.DefaultMessageBuilder;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.internal.util.message.ItemSequenceInfoUtils;
import org.mule.runtime.core.privileged.connector.DefaultReplyToHandler;
import org.mule.runtime.core.privileged.connector.ReplyToHandler;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.event.DefaultMuleSession;
import org.mule.runtime.core.privileged.event.MuleSession;
import org.mule.runtime.core.privileged.store.DeserializationPostInitialisable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventBuilder
implements InternalEvent.Builder {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMessageBuilder.class);
    private BaseEventContext context;
    private Function<EventContext, Message> messageFactory;
    private boolean varsModified = false;
    private Map<String, TypedValue<?>> flowVariables = new HashMap();
    private CaseInsensitiveHashMap<String, TypedValue<?>> originalVars;
    private Map<String, Object> internalParameters = new HashMap<String, Object>(4);
    private Error error;
    private Optional<ItemSequenceInfo> itemSequenceInfo = Optional.empty();
    private String legacyCorrelationId;
    private ReplyToHandler replyToHandler;
    private Object replyToDestination;
    private MuleSession session;
    private SecurityContext securityContext;
    private InternalEvent originalEvent;
    private boolean modified;
    private boolean notificationsEnabled = true;

    public DefaultEventBuilder(BaseEventContext messageContext) {
        this.context = messageContext;
        this.session = new DefaultMuleSession();
        this.originalVars = CaseInsensitiveHashMap.emptyCaseInsensitiveMap();
    }

    public DefaultEventBuilder(InternalEvent event) {
        this.context = event.getContext();
        this.originalEvent = event;
        this.messageFactory = e -> event.getMessage();
        this.itemSequenceInfo = event.getItemSequenceInfo();
        this.legacyCorrelationId = event.getLegacyCorrelationId();
        this.replyToHandler = event.getReplyToHandler();
        this.replyToDestination = event.getReplyToDestination();
        this.securityContext = event.getSecurityContext();
        this.session = event.getSession();
        this.error = event.getError().orElse(null);
        this.notificationsEnabled = event.isNotificationsEnabled();
        this.originalVars = (CaseInsensitiveHashMap)event.getVariables();
        this.internalParameters.putAll(event.getInternalParameters());
    }

    public DefaultEventBuilder(BaseEventContext messageContext, InternalEvent event) {
        this(event);
        this.context = messageContext;
        this.modified = true;
    }

    @Override
    public DefaultEventBuilder message(Message message) {
        Objects.requireNonNull(message);
        this.messageFactory = e -> message;
        this.modified = true;
        return this;
    }

    @Override
    public InternalEvent.Builder message(Function<EventContext, Message> messageFactory) {
        Objects.requireNonNull(messageFactory);
        this.messageFactory = messageFactory;
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder variables(Map<String, ?> flowVariables) {
        this.copyFromTo(flowVariables, this.flowVariables);
        this.varsModified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder addVariable(String key, Object value) {
        this.initVariables();
        this.flowVariables.put(key, new TypedValue<Object>(value, DataType.fromObject(value)));
        this.varsModified = true;
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder addVariable(String key, Object value, DataType dataType) {
        this.initVariables();
        this.flowVariables.put(key, new TypedValue<Object>(value, dataType));
        this.varsModified = true;
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder removeVariable(String key) {
        this.initVariables();
        this.modified = this.flowVariables.remove(key) != null || this.modified;
        this.varsModified = this.varsModified || this.modified;
        return this;
    }

    @Override
    public DefaultEventBuilder internalParameters(Map<String, ?> internalParameters) {
        this.internalParameters.clear();
        this.internalParameters.putAll(internalParameters);
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder addInternalParameter(String key, Object value) {
        this.internalParameters.put(key, value);
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder removeInternalParameter(String key) {
        this.modified = this.internalParameters.remove(key) != null || this.modified;
        return this;
    }

    @Override
    public DefaultEventBuilder correlationId(String correlationId) {
        this.legacyCorrelationId = correlationId;
        this.modified = true;
        return this;
    }

    @Override
    @Deprecated
    public DefaultEventBuilder groupCorrelation(Optional<GroupCorrelation> correlation) {
        return this.itemSequenceInfo((Optional)Optional.ofNullable(ItemSequenceInfoUtils.fromGroupCorrelation(correlation.orElse(null))));
    }

    @Override
    public DefaultEventBuilder itemSequenceInfo(Optional<ItemSequenceInfo> itemSequenceInfo) {
        this.itemSequenceInfo = itemSequenceInfo;
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder error(Error error) {
        this.error = error;
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder replyToHandler(ReplyToHandler replyToHandler) {
        this.replyToHandler = replyToHandler;
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder replyToDestination(Object replyToDestination) {
        this.replyToDestination = replyToDestination;
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder session(MuleSession session) {
        this.session = session;
        this.modified = true;
        return this;
    }

    @Override
    public DefaultEventBuilder securityContext(SecurityContext securityContext) {
        SecurityContext originalValue = this.securityContext;
        this.securityContext = securityContext;
        this.modified = originalValue != securityContext;
        return this;
    }

    @Override
    public DefaultEventBuilder disableNotifications() {
        this.notificationsEnabled = false;
        this.modified = true;
        return this;
    }

    @Override
    public InternalEvent build() {
        if (this.originalEvent != null && !this.modified) {
            return this.originalEvent;
        }
        Message message = Objects.requireNonNull(this.messageFactory.apply(this.context));
        this.initVariables();
        return new InternalEventImplementation(this.context, message, this.varsModified ? this.flowVariables : this.originalVars, this.internalParameters, this.session, this.securityContext, this.replyToDestination, this.replyToHandler, this.itemSequenceInfo, this.error, this.legacyCorrelationId, this.notificationsEnabled);
    }

    protected void initVariables() {
        if (!this.varsModified) {
            this.flowVariables.putAll(this.originalVars);
        }
    }

    private void copyFromTo(Map<String, ?> source, Map<String, TypedValue<?>> target) {
        target.clear();
        for (Map.Entry<String, ?> entry : source.entrySet()) {
            if (entry.getValue() instanceof TypedValue) {
                target.put(entry.getKey(), (TypedValue)entry.getValue());
                continue;
            }
            target.put(entry.getKey(), new TypedValue(entry.getValue(), DataType.fromObject(entry.getValue())));
        }
        this.modified = true;
    }

    public static class InternalEventImplementation
    implements InternalEvent,
    DeserializationPostInitialisable {
        private static final long serialVersionUID = 1L;
        private BaseEventContext context;
        private Message message;
        private final MuleSession session;
        private SecurityContext securityContext;
        private final ReplyToHandler replyToHandler;
        private final Object replyToDestination;
        private final boolean notificationsEnabled;
        private final CaseInsensitiveHashMap<String, TypedValue<?>> variables;
        private final Map<String, ?> internalParameters;
        private final String legacyCorrelationId;
        private final Error error;
        private ItemSequenceInfo itemSequenceInfo;
        private transient LazyValue<BindingContext> bindingContextBuilder = new LazyValue<Supplier<BindingContext>>(() -> BindingContextUtils.addEventBindings(this, BindingContextUtils.NULL_BINDING_CONTEXT));

        private InternalEventImplementation(BaseEventContext context, Message message, Map<String, TypedValue<?>> variables, Map<String, ?> internalParameters, MuleSession session, SecurityContext securityContext, Object replyToDestination, ReplyToHandler replyToHandler, Optional<ItemSequenceInfo> itemSequenceInfo, Error error, String legacyCorrelationId, boolean notificationsEnabled) {
            this.context = context;
            this.session = session;
            this.securityContext = securityContext;
            this.message = message;
            this.variables = (variables instanceof CaseInsensitiveHashMap ? (CaseInsensitiveHashMap)variables : new CaseInsensitiveHashMap(variables)).toImmutableCaseInsensitiveMap();
            this.internalParameters = internalParameters;
            this.replyToHandler = replyToHandler;
            this.replyToDestination = replyToDestination;
            this.itemSequenceInfo = itemSequenceInfo.orElse(null);
            this.error = error;
            this.legacyCorrelationId = legacyCorrelationId;
            this.notificationsEnabled = notificationsEnabled;
        }

        private InternalEventImplementation(BaseEventContext context, Message message, CaseInsensitiveHashMap<String, TypedValue<?>> variables, Map<String, ?> internalParameters, MuleSession session, SecurityContext securityContext, Object replyToDestination, ReplyToHandler replyToHandler, Optional<ItemSequenceInfo> itemSequenceInfo, Error error, String legacyCorrelationId, boolean notificationsEnabled) {
            this.context = context;
            this.session = session;
            this.securityContext = securityContext;
            this.message = message;
            this.variables = variables;
            this.internalParameters = internalParameters;
            this.replyToHandler = replyToHandler;
            this.replyToDestination = replyToDestination;
            this.itemSequenceInfo = itemSequenceInfo.orElse(null);
            this.error = error;
            this.legacyCorrelationId = legacyCorrelationId;
            this.notificationsEnabled = notificationsEnabled;
        }

        @Override
        public BaseEventContext getContext() {
            return this.context;
        }

        @Override
        public Message getMessage() {
            return this.message;
        }

        @Override
        public Optional<Authentication> getAuthentication() {
            if (this.securityContext == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(this.securityContext.getAuthentication());
        }

        @Override
        public Optional<Error> getError() {
            return Optional.ofNullable(this.error);
        }

        @Override
        public byte[] getMessageAsBytes(MuleContext muleContext) throws MuleException {
            try {
                return (byte[])this.transformMessage(DataType.BYTE_ARRAY, muleContext);
            }
            catch (Exception e) {
                throw new DefaultMuleException(CoreMessages.cannotReadPayloadAsBytes(this.message.getPayload().getValue().getClass().getName()), (Throwable)e);
            }
        }

        @Override
        public Object transformMessage(DataType outputType, MuleContext muleContext) throws MessageTransformerException {
            if (outputType == null) {
                throw new MessageTransformerException(CoreMessages.objectIsNull("outputType"), null, this.message);
            }
            Message transformedMessage = muleContext.getTransformationService().transform(this.message, outputType);
            if (this.message.getPayload().getDataType().isStreamType()) {
                this.setMessage(transformedMessage);
            }
            return transformedMessage.getPayload().getValue();
        }

        @Override
        public String getMessageAsString(MuleContext muleContext) throws MuleException {
            return this.getMessageAsString(this.getMessage().getPayload().getDataType().getMediaType().getCharset().orElse(SystemUtils.getDefaultEncoding(muleContext)), muleContext);
        }

        @Override
        public String getMessageAsString(Charset encoding, MuleContext muleContext) throws MuleException {
            try {
                Message transformedMessage = muleContext.getTransformationService().transform(this.message, DataType.builder().type(String.class).charset(encoding).build());
                if (this.message.getPayload().getDataType().isStreamType()) {
                    this.setMessage(transformedMessage);
                }
                return (String)transformedMessage.getPayload().getValue();
            }
            catch (Exception e) {
                throw new DefaultMuleException(CoreMessages.cannotReadPayloadAsString(this.message.getClass().getName()), (Throwable)e);
            }
        }

        public String toString() {
            return "DefaultMuleEvent{" + System.lineSeparator() + "  context=" + this.context + System.lineSeparator() + "  message=" + this.message + System.lineSeparator() + "  variables=" + this.variables + System.lineSeparator() + "  error=" + this.error + System.lineSeparator() + '}';
        }

        @Override
        public MuleSession getSession() {
            return this.session;
        }

        private void initAfterDeserialisation(MuleContext muleContext) throws MuleException {
            if (this.message instanceof InternalMessage) {
                this.setMessage(this.message);
            }
            if (this.replyToHandler instanceof DefaultReplyToHandler) {
                ((DefaultReplyToHandler)this.replyToHandler).initAfterDeserialisation(muleContext);
            }
            if (this.replyToDestination instanceof DeserializationPostInitialisable) {
                try {
                    DeserializationPostInitialisable.Implementation.init(this.replyToDestination, muleContext);
                }
                catch (Exception e) {
                    throw new DefaultMuleException(e);
                }
            }
            this.bindingContextBuilder = new LazyValue<Supplier<BindingContext>>(() -> BindingContextUtils.addEventBindings(this, BindingContextUtils.NULL_BINDING_CONTEXT));
        }

        @Override
        public ReplyToHandler getReplyToHandler() {
            return this.replyToHandler;
        }

        @Override
        public Object getReplyToDestination() {
            return this.replyToDestination;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            for (Map.Entry<String, TypedValue<?>> entry : this.variables.entrySet()) {
                TypedValue<?> value = entry.getValue();
                if (value == null || value instanceof Serializable) continue;
                String message = String.format("Unable to serialize the flow variable %s, which is of type %s ", entry.getKey(), value);
                logger.error(message);
                throw new IOException(message);
            }
        }

        private void setMessage(Message message) {
            this.message = message;
        }

        @Override
        public Map<String, TypedValue<?>> getVariables() {
            return this.variables.toImmutableCaseInsensitiveMap();
        }

        @Override
        public boolean isNotificationsEnabled() {
            return this.notificationsEnabled;
        }

        @Override
        public FlowCallStack getFlowCallStack() {
            return this.context.getFlowCallStack();
        }

        @Override
        public SecurityContext getSecurityContext() {
            return this.securityContext;
        }

        @Override
        public Map<String, ?> getInternalParameters() {
            return Collections.unmodifiableMap(this.internalParameters);
        }

        @Override
        public <T> T getInternalParameter(String key) {
            return (T)this.internalParameters.get(key);
        }

        @Override
        public Optional<GroupCorrelation> getGroupCorrelation() {
            return Optional.ofNullable(ItemSequenceInfoUtils.toGroupCorrelation(this.itemSequenceInfo));
        }

        @Override
        public Optional<ItemSequenceInfo> getItemSequenceInfo() {
            return Optional.ofNullable(this.itemSequenceInfo);
        }

        @Override
        public String getCorrelationId() {
            return this.legacyCorrelationId != null ? this.legacyCorrelationId : this.getContext().getCorrelationId();
        }

        @Override
        @Deprecated
        public String getLegacyCorrelationId() {
            return this.legacyCorrelationId;
        }

        @Override
        public BindingContext asBindingContext() {
            return this.bindingContextBuilder.get();
        }
    }
}

