/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.policy.SourcePolicyParametersTransformer;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.policy.AbstractCompositePolicy;
import org.mule.runtime.core.internal.policy.FlowExecutionException;
import org.mule.runtime.core.internal.policy.MessageSourceResponseParametersProcessor;
import org.mule.runtime.core.internal.policy.SourcePolicy;
import org.mule.runtime.core.internal.policy.SourcePolicyFailureResult;
import org.mule.runtime.core.internal.policy.SourcePolicyProcessorFactory;
import org.mule.runtime.core.internal.policy.SourcePolicySuccessResult;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class CompositeSourcePolicy
extends AbstractCompositePolicy<SourcePolicyParametersTransformer, MessageSourceResponseParametersProcessor>
implements SourcePolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeSourcePolicy.class);
    private final Processor flowExecutionProcessor;
    private final SourcePolicyProcessorFactory sourcePolicyProcessorFactory;
    private Map<String, Object> originalResponseParameters;
    private Map<String, Object> originalFailureResponseParameters;

    public CompositeSourcePolicy(List<Policy> parameterizedPolicies, Optional<SourcePolicyParametersTransformer> sourcePolicyParametersTransformer, SourcePolicyProcessorFactory sourcePolicyProcessorFactory, Processor flowExecutionProcessor, MessageSourceResponseParametersProcessor messageSourceResponseParametersProcessor) {
        super(parameterizedPolicies, sourcePolicyParametersTransformer, messageSourceResponseParametersProcessor);
        this.sourcePolicyProcessorFactory = sourcePolicyProcessorFactory;
        this.flowExecutionProcessor = flowExecutionProcessor;
    }

    @Override
    protected Publisher<CoreEvent> processNextOperation(CoreEvent event, MessageSourceResponseParametersProcessor parametersProcessor) {
        return Mono.just(event).transform(this.flowExecutionProcessor).map(flowExecutionResponse -> {
            this.originalResponseParameters = parametersProcessor.getSuccessfulExecutionResponseParametersFunction().apply((CoreEvent)flowExecutionResponse);
            Message message = this.getParametersTransformer().map(parametersTransformer -> parametersTransformer.fromSuccessResponseParametersToMessage(this.originalResponseParameters)).orElseGet(flowExecutionResponse::getMessage);
            return CoreEvent.builder(event).message(message).build();
        }).onErrorMap(MessagingException.class, messagingException -> {
            this.originalFailureResponseParameters = parametersProcessor.getFailedExecutionResponseParametersFunction().apply(messagingException.getEvent());
            Message message = this.getParametersTransformer().map(parametersTransformer -> parametersTransformer.fromFailureResponseParametersToMessage(this.originalFailureResponseParameters)).orElse(messagingException.getEvent().getMessage());
            FlowExecutionException flowExecutionException = new FlowExecutionException(CoreEvent.builder(messagingException.getEvent()).message(message).build(), messagingException.getCause(), messagingException.getFailingComponent());
            if (messagingException.getInfo().containsKey("Logged")) {
                flowExecutionException.addInfo("Logged", messagingException.getInfo().get("Logged"));
            }
            return flowExecutionException;
        }).doOnError(e -> !(e instanceof MessagingException), e -> LOGGER.error(e.getMessage(), e));
    }

    @Override
    protected Publisher<CoreEvent> processPolicy(Policy policy, Processor nextProcessor, CoreEvent event) {
        return Mono.just(event).doOnNext(s -> this.logEvent(this.getCoreEventId(event), this.getPolicyName(policy), () -> this.getCoreEventAttributesAsString(event), "Starting Policy ")).transform(this.sourcePolicyProcessorFactory.createSourcePolicy(policy, nextProcessor)).doOnNext(responseEvent -> this.logEvent(this.getCoreEventId((CoreEvent)responseEvent), this.getPolicyName(policy), () -> this.getCoreEventAttributesAsString((CoreEvent)responseEvent), "At the end of the Policy "));
    }

    @Override
    public Publisher<Either<SourcePolicyFailureResult, SourcePolicySuccessResult>> process(CoreEvent sourceEvent, MessageSourceResponseParametersProcessor messageSourceResponseParametersProcessor) {
        return Mono.from(MessageProcessors.process(sourceEvent, this.getPolicyProcessor())).map(policiesResultEvent -> {
            Supplier<Map<String, Object>> responseParameters = () -> this.getParametersTransformer().map(parametersTransformer -> this.concatMaps(this.originalResponseParameters, parametersTransformer.fromMessageToSuccessResponseParameters(policiesResultEvent.getMessage()))).orElse(this.originalResponseParameters);
            return Either.right(new SourcePolicySuccessResult((CoreEvent)policiesResultEvent, responseParameters, messageSourceResponseParametersProcessor));
        }).doOnNext(result -> this.logSourcePolicySuccessfullResult((SourcePolicySuccessResult)result.getRight())).doOnError(e -> !(e instanceof FlowExecutionException) && !(e instanceof MessagingException), e -> LOGGER.error(e.getMessage(), e)).onErrorResume(FlowExecutionException.class, e -> {
            Supplier<Map<String, Object>> responseParameters = () -> this.getParametersTransformer().map(parametersTransformer -> this.concatMaps(this.originalFailureResponseParameters, parametersTransformer.fromMessageToErrorResponseParameters(e.getEvent().getMessage()))).orElse(this.originalFailureResponseParameters);
            return Mono.just(Either.left(new SourcePolicyFailureResult((MessagingException)e, responseParameters)));
        }).onErrorResume(MessagingException.class, e -> {
            Supplier<Map<String, Object>> responseParameters = () -> this.getParametersTransformer().map(parametersTransformer -> this.concatMaps(this.originalFailureResponseParameters, parametersTransformer.fromMessageToErrorResponseParameters(e.getEvent().getMessage()))).orElse(this.originalFailureResponseParameters);
            return Mono.just(Either.left(new SourcePolicyFailureResult((MessagingException)e, responseParameters))).doOnNext(result -> this.logSourcePolicyFailureResult((SourcePolicyFailureResult)result.getLeft()));
        });
    }

    private Map<String, Object> concatMaps(Map<String, Object> originalResponseParameters, Map<String, Object> policyResponseParameters) {
        if (originalResponseParameters == null) {
            return policyResponseParameters;
        }
        HashMap<String, Object> concatMap = new HashMap<String, Object>(originalResponseParameters);
        policyResponseParameters.forEach((k, v) -> concatMap.merge((String)k, v, (v1, v2) -> v2));
        return concatMap;
    }

    private void logEvent(String eventId, String policyName, Supplier<String> message, String startingMessage) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Event Id: " + eventId + ".\n" + startingMessage + policyName + "\n" + message.get());
        }
    }

    private String getCoreEventId(CoreEvent event) {
        return event.getContext().getId();
    }

    private String getCoreEventAttributesAsString(CoreEvent event) {
        if (event.getMessage() == null || event.getMessage().getAttributes() == null || event.getMessage().getAttributes().getValue() == null) {
            return "";
        }
        return event.getMessage().getAttributes().getValue().toString();
    }

    private String getPolicyName(Policy policy) {
        return policy.getPolicyId();
    }

    private void logSourcePolicySuccessfullResult(SourcePolicySuccessResult result) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Event id: " + result.getResult().getContext().getId() + "\nFinished processing. \n" + this.getCoreEventAttributesAsString(result.getResult()));
        }
    }

    private void logSourcePolicyFailureResult(SourcePolicyFailureResult result) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Event id: " + result.getMessagingException().getEvent().getContext().getId() + "\nFinished processing with failure. \nError message: " + result.getMessagingException().getMessage());
        }
    }
}

