/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.policy.OperationPolicyParametersTransformer;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.policy.PolicyProvider;
import org.mule.runtime.core.api.policy.PolicyStateHandler;
import org.mule.runtime.core.api.policy.SourcePolicyParametersTransformer;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.policy.CompositeOperationPolicy;
import org.mule.runtime.core.internal.policy.CompositeSourcePolicy;
import org.mule.runtime.core.internal.policy.DefaultOperationPolicyProcessorFactory;
import org.mule.runtime.core.internal.policy.DefaultSourcePolicyProcessorFactory;
import org.mule.runtime.core.internal.policy.MessageSourceResponseParametersProcessor;
import org.mule.runtime.core.internal.policy.NullPolicyProvider;
import org.mule.runtime.core.internal.policy.OperationExecutionFunction;
import org.mule.runtime.core.internal.policy.OperationPolicy;
import org.mule.runtime.core.internal.policy.OperationPolicyProcessorFactory;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.core.internal.policy.PolicyPointcutParametersManager;
import org.mule.runtime.core.internal.policy.SourcePolicy;
import org.mule.runtime.core.internal.policy.SourcePolicyFailureResult;
import org.mule.runtime.core.internal.policy.SourcePolicyProcessorFactory;
import org.mule.runtime.core.internal.policy.SourcePolicySuccessResult;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.policy.api.OperationPolicyPointcutParametersFactory;
import org.mule.runtime.policy.api.PolicyPointcutParameters;
import org.mule.runtime.policy.api.SourcePolicyPointcutParametersFactory;
import reactor.core.publisher.Mono;

public class DefaultPolicyManager
implements PolicyManager,
Initialisable {
    @Inject
    private MuleContext muleContext;
    @Inject
    private PolicyStateHandler policyStateHandler;
    private final ConcurrentHashMap<ComponentIdentifier, Optional<SourcePolicyParametersTransformer>> sourceParametersTransformers = new ConcurrentHashMap();
    private final ConcurrentHashMap<ComponentIdentifier, Optional<OperationPolicyParametersTransformer>> operationParametersTransformers = new ConcurrentHashMap();
    private PolicyProvider policyProvider;
    private OperationPolicyProcessorFactory operationPolicyProcessorFactory;
    private SourcePolicyProcessorFactory sourcePolicyProcessorFactory;
    private PolicyPointcutParametersManager policyPointcutParametersManager;

    @Override
    public SourcePolicy createSourcePolicyInstance(Component source, CoreEvent sourceEvent, Processor flowExecutionProcessor, MessageSourceResponseParametersProcessor messageSourceResponseParametersProcessor) {
        PolicyPointcutParameters sourcePointcutParameters = this.policyPointcutParametersManager.createSourcePointcutParameters(source, sourceEvent);
        List<Policy> parameterizedPolicies = this.policyProvider.findSourceParameterizedPolicies(sourcePointcutParameters);
        if (parameterizedPolicies.isEmpty()) {
            return (event, respParamProcessor) -> Mono.from(MessageProcessors.process(event, flowExecutionProcessor)).map(flowExecutionResult -> Either.right(new SourcePolicySuccessResult((CoreEvent)flowExecutionResult, () -> respParamProcessor.getSuccessfulExecutionResponseParametersFunction().apply((CoreEvent)flowExecutionResult), respParamProcessor))).onErrorResume(Exception.class, e -> {
                MessagingException messagingException = e instanceof MessagingException ? (MessagingException)e : new MessagingException(event, (Throwable)e, (Component)((Object)flowExecutionProcessor));
                return Mono.just(Either.left(new SourcePolicyFailureResult(messagingException, () -> respParamProcessor.getFailedExecutionResponseParametersFunction().apply(messagingException.getEvent()))));
            });
        }
        return new CompositeSourcePolicy(parameterizedPolicies, this.lookupSourceParametersTransformer(source.getLocation().getComponentIdentifier().getIdentifier()), this.sourcePolicyProcessorFactory, flowExecutionProcessor, messageSourceResponseParametersProcessor);
    }

    @Override
    public OperationPolicy createOperationPolicy(Component operation, CoreEvent event, Map<String, Object> operationParameters, OperationExecutionFunction operationExecutionFunction) {
        PolicyPointcutParameters operationPointcutParameters = this.policyPointcutParametersManager.createOperationPointcutParameters(operation, event, operationParameters);
        List<Policy> parameterizedPolicies = this.policyProvider.findOperationParameterizedPolicies(operationPointcutParameters);
        if (parameterizedPolicies.isEmpty()) {
            return (operationEvent, opParamProcessor) -> operationExecutionFunction.execute(opParamProcessor.getOperationParameters(), operationEvent);
        }
        return new CompositeOperationPolicy(parameterizedPolicies, this.lookupOperationParametersTransformer(operation.getLocation().getComponentIdentifier().getIdentifier()), this.operationPolicyProcessorFactory, () -> operationParameters, operationExecutionFunction);
    }

    private Optional<OperationPolicyParametersTransformer> lookupOperationParametersTransformer(ComponentIdentifier componentIdentifier) {
        Optional<OperationPolicyParametersTransformer> cached = this.operationParametersTransformers.get(componentIdentifier);
        if (cached != null) {
            return cached;
        }
        MuleRegistry registry = ((MuleContextWithRegistries)this.muleContext).getRegistry();
        return this.operationParametersTransformers.computeIfAbsent(componentIdentifier, cId -> registry.lookupObjects(OperationPolicyParametersTransformer.class).stream().filter(policyOperationParametersTransformer -> policyOperationParametersTransformer.supports((ComponentIdentifier)cId)).findAny());
    }

    private Optional<SourcePolicyParametersTransformer> lookupSourceParametersTransformer(ComponentIdentifier componentIdentifier) {
        Optional<SourcePolicyParametersTransformer> cached = this.sourceParametersTransformers.get(componentIdentifier);
        if (cached != null) {
            return cached;
        }
        MuleRegistry registry = ((MuleContextWithRegistries)this.muleContext).getRegistry();
        return this.sourceParametersTransformers.computeIfAbsent(componentIdentifier, cId -> registry.lookupObjects(SourcePolicyParametersTransformer.class).stream().filter(policyOperationParametersTransformer -> policyOperationParametersTransformer.supports((ComponentIdentifier)cId)).findAny());
    }

    @Override
    public void initialise() throws InitialisationException {
        this.operationPolicyProcessorFactory = new DefaultOperationPolicyProcessorFactory(this.policyStateHandler);
        this.sourcePolicyProcessorFactory = new DefaultSourcePolicyProcessorFactory(this.policyStateHandler);
        MuleRegistry registry = ((MuleContextWithRegistries)this.muleContext).getRegistry();
        this.policyProvider = registry.lookupLocalObjects(PolicyProvider.class).stream().findFirst().orElse(new NullPolicyProvider());
        this.policyPointcutParametersManager = new PolicyPointcutParametersManager(registry.lookupObjects(SourcePolicyPointcutParametersFactory.class), registry.lookupObjects(OperationPolicyPointcutParametersFactory.class));
    }

    @Override
    public void disposePoliciesResources(String executionIdentifier) {
        this.policyStateHandler.destroyState(executionIdentifier);
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

