/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.rx;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.mule.runtime.core.internal.exception.MessagingException;
import reactor.core.publisher.FluxSink;

public class FluxSinkRecorder<T>
implements Consumer<FluxSink<T>> {
    private volatile FluxSink<T> fluxSink;
    private final List<Runnable> bufferedEvents = new ArrayList<Runnable>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(FluxSink<T> fluxSink) {
        FluxSinkRecorder fluxSinkRecorder = this;
        synchronized (fluxSinkRecorder) {
            this.fluxSink = fluxSink;
        }
        this.bufferedEvents.forEach(e -> e.run());
    }

    public FluxSink<T> getFluxSink() {
        return this.fluxSink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void next(T response) {
        boolean present = true;
        FluxSinkRecorder fluxSinkRecorder = this;
        synchronized (fluxSinkRecorder) {
            if (this.fluxSink == null) {
                present = false;
                this.bufferedEvents.add(() -> this.fluxSink.next(response));
            }
        }
        if (present) {
            this.fluxSink.next(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(MessagingException error) {
        boolean present = true;
        FluxSinkRecorder fluxSinkRecorder = this;
        synchronized (fluxSinkRecorder) {
            if (this.fluxSink == null) {
                present = false;
                this.bufferedEvents.add(() -> this.fluxSink.error(error));
            }
        }
        if (present) {
            this.fluxSink.error(error);
        }
    }
}

