/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.lifecycle;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeMap;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ConnectException;
import org.mule.runtime.core.api.lifecycle.LifecycleCallback;
import org.mule.runtime.core.api.lifecycle.LifecycleManager;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.core.internal.lifecycle.DefaultLifecycleState;
import org.mule.runtime.core.privileged.transport.LegacyConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLifecycleManager<O>
implements LifecycleManager {
    protected final transient Logger logger = LoggerFactory.getLogger(AbstractLifecycleManager.class);
    protected String lifecycleManagerId;
    protected volatile String currentPhase = "not in lifecycle";
    protected volatile String executingPhase = null;
    private final Set<String> directTransitions = new HashSet<String>();
    protected Set<String> phaseNames = new LinkedHashSet<String>(4);
    protected Set<String> completedPhases = new LinkedHashSet<String>(4);
    protected O object;
    protected LifecycleState state;
    private volatile String lastPhaseExecuted;
    private volatile boolean lastPhaseExecutionFailed;
    private final TreeMap<String, LifecycleCallback> callbacks = new TreeMap();

    public AbstractLifecycleManager(String id, O object) {
        this.lifecycleManagerId = id;
        this.object = object;
        this.state = this.createLifecycleState();
        this.currentPhase = "not in lifecycle";
        this.completedPhases.add(this.currentPhase);
        this.registerTransitions();
    }

    protected abstract void registerTransitions();

    public void registerLifecycleCallback(String phaseName, LifecycleCallback<O> callback) {
        this.callbacks.put(phaseName, callback);
    }

    protected LifecycleState createLifecycleState() {
        return new DefaultLifecycleState(this);
    }

    protected void addDirectTransition(String phase1, String phase2) {
        this.directTransitions.add(phase1 + "-" + phase2);
        this.phaseNames.add(phase1);
        this.phaseNames.add(phase2);
    }

    @Override
    public void checkPhase(String name) throws IllegalStateException {
        if (this.lastPhaseExecutionFailed) {
            return;
        }
        if (this.executingPhase != null) {
            if (name.equalsIgnoreCase(this.executingPhase)) {
                throw new IllegalStateException("Phase '" + name + "' is already currently being executed for object '" + this.object.toString() + "'");
            }
            throw new IllegalStateException("Cannot fire phase '" + name + "' for object '" + this.object.toString() + "', currently executing lifecycle phase: " + this.executingPhase);
        }
        if (name.equalsIgnoreCase(this.currentPhase)) {
            throw new IllegalStateException("Already in lifecycle phase '" + name + "' for object '" + this.object.toString() + "', cannot fire the same phase twice");
        }
        if (!this.phaseNames.contains(name)) {
            throw new IllegalStateException("Phase does not exist: '" + name + "' for object '" + this.object.toString() + "'");
        }
        if (this.isDirectTransition(name)) {
            return;
        }
        throw new IllegalStateException("Lifecycle Manager '" + this.lifecycleManagerId + "' phase '" + this.currentPhase + "' does not support phase '" + name + "' for object '" + this.object.toString() + "'");
    }

    public O getLifecycleObject() {
        return this.object;
    }

    @Override
    public synchronized void fireLifecycle(String phase) throws LifecycleException {
        this.checkPhase(phase);
        this.invokePhase(phase, this.object, this.callbacks.get(phase));
    }

    protected void invokePhase(String phase, Object object, LifecycleCallback callback) throws LifecycleException {
        try {
            this.lastPhaseExecuted = phase;
            this.setExecutingPhase(phase);
            callback.onTransition(phase, object);
            this.setCurrentPhase(phase);
            this.lastPhaseExecutionFailed = false;
        }
        catch (ConnectException ce) {
            this.lastPhaseExecutionFailed = true;
            this.doOnConnectException(ce);
        }
        catch (LifecycleException le) {
            this.lastPhaseExecutionFailed = true;
            throw le;
        }
        catch (Exception e) {
            this.lastPhaseExecutionFailed = true;
            throw new LifecycleException(e, object);
        }
        finally {
            this.setExecutingPhase(null);
        }
    }

    protected void doOnConnectException(ConnectException ce) throws LifecycleException {
        MuleContext muleContext = ((LegacyConnector)ce.getFailed()).getMuleContext();
        muleContext.getExceptionListener().handleException(ce);
    }

    @Override
    public void applyPhase(Object object, String startPhase, String toPhase) throws LifecycleException {
        if (startPhase == null || toPhase == null) {
            throw new IllegalArgumentException("toPhase and fromPhase must be null");
        }
        if (!this.phaseNames.contains(startPhase)) {
            throw new IllegalArgumentException("fromPhase '" + startPhase + "' not a valid phase.");
        }
        if (!this.phaseNames.contains(toPhase)) {
            throw new IllegalArgumentException("toPhase '" + startPhase + "' not a valid phase.");
        }
        boolean started = false;
        for (String phaseName : this.phaseNames) {
            if (started) {
                this.invokePhase(object, phaseName);
            }
            if (toPhase.equals(phaseName)) break;
            if (!phaseName.equals(startPhase)) continue;
            started = true;
        }
    }

    @Override
    public void applyCompletedPhases(Object object) throws LifecycleException {
        String lastPhase = "not in lifecycle";
        for (String phase : this.completedPhases) {
            if (!this.isDirectTransition(lastPhase, phase)) continue;
            this.invokePhase(object, phase);
            lastPhase = phase;
        }
    }

    private void invokePhase(Object object, String phase) throws LifecycleException {
        try {
            this.callbacks.get(phase).onTransition(phase, object);
        }
        catch (MuleException e) {
            throw new LifecycleException(e, object);
        }
    }

    @Override
    public boolean isDirectTransition(String destinationPhase) {
        return this.isDirectTransition(this.getCurrentPhase(), destinationPhase);
    }

    protected boolean isDirectTransition(String startPhase, String endPhase) {
        String key = startPhase + "-" + endPhase;
        return this.directTransitions.contains(key);
    }

    @Override
    public String getCurrentPhase() {
        return this.currentPhase;
    }

    protected void setCurrentPhase(String currentPhase) {
        this.currentPhase = currentPhase;
        this.completedPhases.add(currentPhase);
        if (currentPhase.equals("stop")) {
            this.completedPhases.remove("start");
        } else if (currentPhase.equals("start")) {
            this.completedPhases.remove("stop");
        } else if (currentPhase.equals("dispose")) {
            this.completedPhases.remove("initialise");
        }
        this.notifyTransition(currentPhase);
    }

    @Override
    public String getExecutingPhase() {
        return this.executingPhase;
    }

    protected void setExecutingPhase(String executingPhase) {
        this.executingPhase = executingPhase;
    }

    protected void notifyTransition(String phase) {
    }

    @Override
    public void reset() {
        this.completedPhases.clear();
        this.setExecutingPhase(null);
        this.setCurrentPhase("not in lifecycle");
        this.completedPhases.add(this.getCurrentPhase());
    }

    @Override
    public boolean isPhaseComplete(String phaseName) {
        return this.completedPhases.contains(phaseName);
    }

    @Override
    public LifecycleState getState() {
        return this.state;
    }

    public String getLastPhaseExecuted() {
        return this.lastPhaseExecuted;
    }

    public boolean isLastPhaseExecutionFailed() {
        return this.lastPhaseExecutionFailed;
    }
}

