/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.util;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;

public final class AttributeEvaluator {
    private static final Pattern SINGLE_EXPRESSION_REGEX_PATTERN = Pattern.compile("^#\\[(?:(?!#\\[).)*]$", 32);
    private static final Set<Class<?>> BLACK_LIST_TYPES = new HashSet<Class>(Arrays.asList(Object.class, InputStream.class, Iterator.class, Serializable.class));
    private String attributeValue;
    private ExtendedExpressionManager expressionManager;
    private Function<CoreEvent, TypedValue> expressionEventResolver;
    private Function<BindingContext, TypedValue> expressionContextResolver;

    public AttributeEvaluator(String attributeValue) {
        this(attributeValue, null);
    }

    public AttributeEvaluator(String attributeValue, DataType expectedDataType) {
        this.attributeValue = this.sanitize(attributeValue);
        switch (this.resolveAttributeType()) {
            case EXPRESSION: {
                if (expectedDataType != null && !BLACK_LIST_TYPES.contains(expectedDataType.getType())) {
                    this.expressionEventResolver = event -> this.expressionManager.evaluate(this.attributeValue, expectedDataType, BindingContextUtils.NULL_BINDING_CONTEXT, (CoreEvent)event);
                    this.expressionContextResolver = context -> this.expressionManager.evaluate(this.attributeValue, expectedDataType, (BindingContext)context);
                    break;
                }
                this.expressionEventResolver = event -> this.expressionManager.evaluate(this.attributeValue, (CoreEvent)event);
                this.expressionContextResolver = context -> this.expressionManager.evaluate(this.attributeValue, (BindingContext)context);
                break;
            }
            case PARSE_EXPRESSION: {
                this.expressionEventResolver = event -> new TypedValue<String>(this.expressionManager.parse(this.attributeValue, (CoreEvent)event, null), DataType.STRING);
                this.expressionContextResolver = context -> {
                    throw new UnsupportedOperationException("Cannot use a PARSE_EXPRESSION attribute type without an event.");
                };
                break;
            }
            case STATIC_VALUE: {
                this.expressionEventResolver = event -> new TypedValue<String>(this.attributeValue, this.attributeValue == null ? DataType.OBJECT : DataType.STRING);
                this.expressionContextResolver = event -> new TypedValue<String>(this.attributeValue, this.attributeValue == null ? DataType.OBJECT : DataType.STRING);
            }
        }
    }

    public AttributeEvaluator initialize(ExtendedExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
        return this;
    }

    private String sanitize(String attributeValue) {
        if (attributeValue != null) {
            attributeValue = attributeValue.trim().replaceAll("\r", "").replaceAll("\t", "");
        }
        return attributeValue;
    }

    private AttributeType resolveAttributeType() {
        if (this.attributeValue != null && SINGLE_EXPRESSION_REGEX_PATTERN.matcher(this.attributeValue).matches()) {
            return AttributeType.EXPRESSION;
        }
        if (this.attributeValue != null && this.isParseExpression(this.attributeValue)) {
            return AttributeType.PARSE_EXPRESSION;
        }
        return AttributeType.STATIC_VALUE;
    }

    private boolean isParseExpression(String attributeValue) {
        int beginExpression = attributeValue.indexOf("#[");
        if (beginExpression == -1) {
            return false;
        }
        String remainingString = attributeValue.substring(beginExpression + "#[".length());
        return remainingString.contains("]");
    }

    public <T> TypedValue<T> resolveTypedValueFromContext(BindingContext context) {
        return this.expressionContextResolver.apply(context);
    }

    public <T> TypedValue<T> resolveTypedValue(CoreEvent event) {
        return this.expressionEventResolver.apply(event);
    }

    public <T> T resolveValue(CoreEvent event) {
        TypedValue<T> resolveTypedValue = this.resolveTypedValue(event);
        return resolveTypedValue.getValue();
    }

    public String getRawValue() {
        return this.attributeValue;
    }

    private static enum AttributeType {
        EXPRESSION,
        PARSE_EXPRESSION,
        STATIC_VALUE;

    }
}

