/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.application;

import java.util.Map;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.core.internal.registry.CompositeMuleRegistryHelper;
import org.mule.runtime.core.internal.registry.DefaultRegistryBroker;
import org.mule.runtime.core.internal.registry.MuleRegistryHelper;
import org.mule.runtime.module.deployment.impl.internal.application.SupportsPropertiesMuleContextBuilder;

public class ApplicationMuleContextBuilder
extends SupportsPropertiesMuleContextBuilder {
    private final String appName;
    private final String defaultEncoding;
    private final MuleContext parentContext;

    public ApplicationMuleContextBuilder(String appName, Map<String, String> appProperties, String defaultEncoding, MuleContext parentContext) {
        super(ArtifactType.APP, appProperties);
        this.appName = appName;
        this.defaultEncoding = defaultEncoding;
        this.parentContext = parentContext;
    }

    @Override
    protected DefaultMuleConfiguration createMuleConfiguration() {
        DefaultMuleConfiguration configuration = new DefaultMuleConfiguration(true);
        this.initializeFromProperties(configuration);
        configuration.setId(this.appName);
        String encoding = this.defaultEncoding;
        if (!StringUtils.isBlank(encoding)) {
            configuration.setDefaultEncoding(encoding);
        }
        return configuration;
    }

    @Override
    protected MuleRegistryHelper getMuleRegistry(DefaultMuleContext muleContext) {
        if (this.parentContext != null && ((DefaultMuleContext)this.parentContext).getRegistry() instanceof MuleRegistryHelper) {
            DefaultRegistryBroker registryBroker = new DefaultRegistryBroker(muleContext, muleContext.getLifecycleInterceptor());
            muleContext.setRegistryBroker(registryBroker);
            return new CompositeMuleRegistryHelper(registryBroker, muleContext, ((DefaultMuleContext)this.parentContext).getRegistry());
        }
        return super.getMuleRegistry(muleContext);
    }
}

