/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import java.io.File;
import java.util.List;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.module.license.api.LicenseValidator;
import org.mule.runtime.module.license.api.PluginLicenseValidationRequest;

public class ArtifactFactoryUtils {
    private ArtifactFactoryUtils() {
    }

    public static File getDeploymentFile(File artifactDir) {
        if (!artifactDir.exists()) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Artifact directory does not exist: '%s'", artifactDir)));
        }
        File deployFile = new File(artifactDir, "mule-deploy.properties");
        if (!deployFile.exists()) {
            return null;
        }
        return deployFile;
    }

    public static void validateArtifactLicense(ClassLoader artifactClassLoader, List<ArtifactPlugin> artifactPlugins, LicenseValidator licenseValidator) {
        artifactPlugins.stream().forEach(artifactPlugin -> ((ArtifactPluginDescriptor)artifactPlugin.getDescriptor()).getLicenseModel().ifPresent(licenseModel -> licenseModel.getRequiredEntitlement().ifPresent(entitlement -> {
            String pluginName = ((ArtifactPluginDescriptor)artifactPlugin.getDescriptor()).getName();
            String providerName = licenseModel.getProvider();
            licenseValidator.validatePluginLicense(PluginLicenseValidationRequest.builder().withEntitlement((String)entitlement).withPluginName(pluginName).withPluginProvider(providerName).withPluginVersion(((ArtifactPluginDescriptor)artifactPlugin.getDescriptor()).getBundleDescriptor().getVersion()).withAllowsEvaluation(licenseModel.isAllowsEvaluation()).withArtifactClassLoader(artifactClassLoader).withPluginClassLoader(artifactPlugin.getArtifactClassLoader().getClassLoader()).build());
        })));
    }
}

