/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.connection;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthModelProperty;
import org.mule.runtime.module.extension.internal.config.dsl.AbstractExtensionObjectFactory;
import org.mule.runtime.module.extension.internal.runtime.config.ConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthManager;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.soap.internal.loader.property.SoapExtensionModelProperty;
import org.mule.runtime.module.extension.soap.internal.runtime.connection.SoapConnectionProviderObjectBuilder;
import org.mule.runtime.soap.api.client.SoapClient;

public class ConnectionProviderObjectFactory
extends AbstractExtensionObjectFactory<ConnectionProviderResolver> {
    private final ConnectionProviderModel providerModel;
    private final ExtensionModel extensionModel;
    private final ExtensionsOAuthManager oauthManager;
    private PoolingProfile poolingProfile = null;
    private ReconnectionConfig reconnectionConfig = ReconnectionConfig.getDefault();
    @Inject
    private MuleContext muleContext;

    public ConnectionProviderObjectFactory(ConnectionProviderModel providerModel, ExtensionModel extensionModel, ExtensionsOAuthManager oauthManager, MuleContext muleContext) {
        super(muleContext);
        this.providerModel = providerModel;
        this.extensionModel = extensionModel;
        this.oauthManager = oauthManager;
    }

    @Override
    public ConnectionProviderResolver doGetObject() throws Exception {
        Callable<ResolverSet> callable = () -> this.getParametersResolver().getParametersAsHashedResolverSet(this.providerModel, this.muleContext);
        ResolverSet resolverSet = ClassUtils.withContextClassLoader(MuleExtensionUtils.getClassLoader(this.extensionModel), callable);
        ConnectionProviderObjectBuilder builder = this.extensionModel.getModelProperty(SoapExtensionModelProperty.class).isPresent() ? new SoapConnectionProviderObjectBuilder(this.providerModel, resolverSet, this.poolingProfile, this.reconnectionConfig, this.extensionModel, this.muleContext) : (this.providerModel.getModelProperty(OAuthModelProperty.class).isPresent() ? new OAuthConnectionProviderObjectBuilder(this.providerModel, resolverSet, this.poolingProfile, this.reconnectionConfig, this.oauthManager, this.extensionModel, this.muleContext) : new DefaultConnectionProviderObjectBuilder(this.providerModel, resolverSet, this.poolingProfile, this.reconnectionConfig, this.extensionModel, this.muleContext));
        return new ConnectionProviderResolver<SoapClient>(builder, resolverSet, this.muleContext);
    }

    public void setPoolingProfile(PoolingProfile poolingProfile) {
        this.poolingProfile = poolingProfile;
    }

    public void setReconnectionConfig(ReconnectionConfig reconnectionConfig) {
        this.reconnectionConfig = reconnectionConfig;
    }
}

