/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.AttributeKeyType;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.LocalDateTimeType;
import org.mule.metadata.api.model.LocalTimeType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NothingType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.PeriodType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.TimeType;
import org.mule.metadata.api.model.TimeZoneType;
import org.mule.metadata.api.model.TupleType;
import org.mule.metadata.api.model.TypeParameterType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.model.impl.DefaultAttributeFieldType;
import org.mule.metadata.api.model.impl.DefaultAttributeKeyType;
import org.mule.metadata.api.model.impl.DefaultFunctionType;
import org.mule.metadata.api.model.impl.DefaultObjectFieldType;
import org.mule.metadata.api.model.impl.DefaultObjectKeyType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.metadata.api.model.impl.DefaultUnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

class MetadataTypeEnricher {
    MetadataTypeEnricher() {
    }

    public MetadataType enrich(MetadataType target, Set<TypeAnnotation> annotations) {
        TypeEnricherVisitor visitor = new TypeEnricherVisitor(target, annotations);
        target.accept(visitor);
        return visitor.type;
    }

    private static class TypeEnricherVisitor
    extends MetadataTypeVisitor {
        private MetadataType type;
        private final MetadataType target;
        private final BaseTypeBuilder typeBuilder;
        private final Set<TypeAnnotation> annotations;

        private TypeEnricherVisitor(MetadataType target, Set<TypeAnnotation> annotations) {
            this.target = target;
            this.annotations = annotations;
            this.typeBuilder = BaseTypeBuilder.create(target.getMetadataFormat());
        }

        @Override
        protected void defaultVisit(MetadataType metadataType) {
            this.type = metadataType;
        }

        @Override
        public void visitAnyType(AnyType anyType) {
            this.type = this.withNewAnnotations(this.typeBuilder.anyType());
        }

        @Override
        public void visitArrayType(ArrayType arrayType) {
            this.type = this.withNewAnnotations(this.typeBuilder.arrayType().of(arrayType.getType()));
        }

        @Override
        public void visitBinaryType(BinaryType binaryType) {
            this.type = this.withNewAnnotations(this.typeBuilder.binaryType());
        }

        @Override
        public void visitBoolean(BooleanType booleanType) {
            this.type = this.withNewAnnotations(this.typeBuilder.booleanType());
        }

        @Override
        public void visitDateTime(DateTimeType dateTimeType) {
            this.type = this.withNewAnnotations(this.typeBuilder.dateTimeType());
        }

        @Override
        public void visitDate(DateType dateType) {
            this.type = this.withNewAnnotations(this.typeBuilder.dateType());
        }

        @Override
        public void visitNumber(NumberType numberType) {
            this.withNewAnnotations(this.typeBuilder.numberType());
        }

        @Override
        public void visitObject(ObjectType objectType) {
            this.type = new DefaultObjectType(objectType.getFields(), objectType.isOrdered(), objectType.getOpenRestriction().orElse(null), objectType.getMetadataFormat(), this.getAllTypeAnnotationsMap());
        }

        @Override
        public void visitString(StringType stringType) {
            this.type = this.withNewAnnotations(this.typeBuilder.stringType());
        }

        @Override
        public void visitTime(TimeType timeType) {
            this.type = this.withNewAnnotations(this.typeBuilder.timeType());
        }

        @Override
        public void visitTuple(TupleType tupleType) {
            this.type = this.withNewAnnotations(this.typeBuilder.tupleType());
        }

        @Override
        public void visitUnion(UnionType unionType) {
            this.type = new DefaultUnionType(unionType.getTypes(), unionType.getMetadataFormat(), this.getAllTypeAnnotationsMap());
        }

        @Override
        public void visitObjectKey(ObjectKeyType type) {
            type = new DefaultObjectKeyType(Optional.ofNullable(type.getName()), Optional.ofNullable(type.getPattern()), type.getAttributes(), type.getMetadataFormat(), this.getAllTypeAnnotationsMap());
        }

        @Override
        public void visitAttributeKey(AttributeKeyType type) {
            type = new DefaultAttributeKeyType(Optional.ofNullable(type.getName()), Optional.ofNullable(type.getPattern()), type.getMetadataFormat(), this.getAllTypeAnnotationsMap());
        }

        @Override
        public void visitAttributeField(AttributeFieldType type) {
            type = new DefaultAttributeFieldType(type.getKey(), type.getValue(), type.isRequired(), type.getMetadataFormat(), this.getAllTypeAnnotationsMap());
        }

        @Override
        public void visitObjectField(ObjectFieldType type) {
            type = new DefaultObjectFieldType(type.getKey(), type.getValue(), type.isRequired(), type.isRepeated(), type.getMetadataFormat(), this.getAllTypeAnnotationsMap());
        }

        @Override
        public void visitNothing(NothingType nothingType) {
            this.type = this.withNewAnnotations(this.typeBuilder.nothingType());
        }

        @Override
        public void visitFunction(FunctionType type) {
            type = new DefaultFunctionType(type.getMetadataFormat(), this.getAllTypeAnnotationsMap(), type.getReturnType(), type.getParameters());
        }

        @Override
        public void visitLocalDateTime(LocalDateTimeType localDateTimeType) {
            this.type = this.withNewAnnotations(this.typeBuilder.localDateTimeType());
        }

        @Override
        public void visitLocalTime(LocalTimeType localTimeType) {
            this.type = this.withNewAnnotations(this.typeBuilder.localTimeType());
        }

        @Override
        public void visitPeriod(PeriodType periodType) {
            this.type = this.withNewAnnotations(this.typeBuilder.localTimeType());
        }

        @Override
        public void visitTimeZone(TimeZoneType timeZoneType) {
            this.type = this.withNewAnnotations(this.typeBuilder.timeZoneType());
        }

        @Override
        public void visitTypeParameter(TypeParameterType defaultTypeParameter) {
            this.type = this.withNewAnnotations(this.typeBuilder.typeParameter(defaultTypeParameter.getName()));
        }

        private <T extends TypeBuilder & WithAnnotation> MetadataType withNewAnnotations(T builder) {
            Set<TypeAnnotation> all = this.getAllTypeAnnotations();
            for (TypeAnnotation typeAnnotation : all) {
                ((WithAnnotation)builder).with(typeAnnotation);
            }
            return builder.build();
        }

        private Map<Class<? extends TypeAnnotation>, TypeAnnotation> getAllTypeAnnotationsMap() {
            return this.getAllTypeAnnotations().stream().collect(Collectors.toMap(Object::getClass, a -> a));
        }

        private Set<TypeAnnotation> getAllTypeAnnotations() {
            LinkedHashSet<TypeAnnotation> all = new LinkedHashSet<TypeAnnotation>(this.annotations);
            all.addAll(this.target.getAnnotations());
            return all;
        }
    }
}

