/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.lang.reflect.Method;
import java.util.Map;
import javax.inject.Inject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.core.api.streaming.iterator.ConsumerStreamingIterator;
import org.mule.runtime.core.api.streaming.iterator.ListConsumer;
import org.mule.runtime.core.api.util.func.CheckedBiFunction;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutorFactory;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;
import org.mule.runtime.module.extension.internal.runtime.execution.ReflectiveExecutorFactoryUtil;
import org.mule.runtime.module.extension.internal.runtime.operation.ReflectiveMethodOperationExecutor;
import org.mule.runtime.module.extension.internal.runtime.streaming.PagingProviderProducer;

public final class PagedReflectiveOperationExecutorFactory<T, M extends ComponentModel>
implements ComponentExecutorFactory<M> {
    private final Method operationMethod;
    private final PagingProviderResultTransformer pagingProviderTransformer = new PagingProviderResultTransformer();
    private final Class<T> implementationClass;

    public PagedReflectiveOperationExecutorFactory(Class<T> implementationClass, Method operationMethod) {
        this.implementationClass = implementationClass;
        this.operationMethod = operationMethod;
    }

    @Override
    public ComponentExecutor<M> createExecutor(M operationModel, Map<String, Object> parameters) {
        return new ReflectiveMethodOperationExecutor<M>(operationModel, this.operationMethod, ReflectiveExecutorFactoryUtil.createDelegate(this.implementationClass, parameters), this.pagingProviderTransformer);
    }

    private class PagingProviderResultTransformer
    implements CheckedBiFunction<Object, ExecutionContext<M>, Object> {
        @Inject
        private ExtensionConnectionSupplier connectionSupplier;

        private PagingProviderResultTransformer() {
        }

        @Override
        public Object applyChecked(Object result, ExecutionContext<M> executionContext) throws Throwable {
            PagingProviderProducer pagingProviderProducer = new PagingProviderProducer((PagingProvider)result, executionContext.getConfiguration().get(), (ExecutionContextAdapter)executionContext, this.connectionSupplier);
            ListConsumer consumer = new ListConsumer(pagingProviderProducer);
            try {
                consumer.loadNextPage();
            }
            catch (Throwable e) {
                throw pagingProviderProducer.getCause(e);
            }
            return new ConsumerStreamingIterator(consumer);
        }
    }
}

