/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.MediaTypeUtils;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.util.StreamingUtils;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.core.internal.util.message.MessageUtils;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.operation.ReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.resulthandler.CollectionReturnHandler;
import org.mule.runtime.module.extension.internal.runtime.operation.resulthandler.MapReturnHandler;
import org.mule.runtime.module.extension.internal.runtime.operation.resulthandler.ReturnHandler;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

abstract class AbstractReturnDelegate
implements ReturnDelegate {
    protected final MuleContext muleContext;
    private boolean returnsListOfMessages = false;
    private final CursorProviderFactory cursorProviderFactory;
    private final MediaType defaultMediaType;
    private boolean isSpecialHandling = false;
    private ReturnHandler returnHandler = ReturnHandler.nullHandler();
    private Charset defaultEncoding;

    protected AbstractReturnDelegate(ComponentModel componentModel, CursorProviderFactory cursorProviderFactory, MuleContext muleContext) {
        if (componentModel instanceof HasOutputModel) {
            HasOutputModel hasOutputModel = (HasOutputModel)((Object)componentModel);
            this.returnsListOfMessages = MuleExtensionUtils.returnsListOfMessages(hasOutputModel);
            MetadataType outputType = hasOutputModel.getOutput().getType();
            if (ExtensionMetadataTypeUtils.isMap(outputType)) {
                this.isSpecialHandling = true;
                this.returnHandler = new MapReturnHandler(hasOutputModel);
            } else if (ExtensionMetadataTypeUtils.isJavaCollection(outputType)) {
                this.isSpecialHandling = true;
                this.returnHandler = new CollectionReturnHandler(outputType);
            }
        }
        this.muleContext = muleContext;
        this.cursorProviderFactory = cursorProviderFactory;
        this.defaultMediaType = org.mule.runtime.module.extension.internal.util.MediaTypeUtils.getDefaultMediaType(componentModel);
        this.defaultEncoding = SystemUtils.getDefaultEncoding(muleContext);
    }

    protected Message toMessage(Object value, ExecutionContextAdapter operationContext) {
        Map<String, Object> params = operationContext.getParameters();
        Optional<MediaType> contextMimeTypeParam = this.getContextMimeType(params);
        Optional<Charset> contextEncodingParam = this.getContextEncoding(params);
        MediaType mediaType = this.resolveMediaType(value, contextMimeTypeParam, contextEncodingParam);
        CoreEvent event = operationContext.getEvent();
        if (value instanceof Result) {
            ConnectionHandler connectionHandler;
            Result resultValue = (Result)((Object)value);
            if (resultValue.getOutput() instanceof InputStream && (connectionHandler = (ConnectionHandler)operationContext.getVariable("MULE_CONNECTION_PARAM")) != null && StreamingUtils.supportsStreaming(operationContext.getComponentModel())) {
                resultValue = resultValue.copy().output(new ConnectedInputStreamWrapper((InputStream)resultValue.getOutput(), connectionHandler)).build();
            }
            return this.isSpecialHandling && this.returnHandler.handles(resultValue.getOutput()) ? MessageUtils.toMessage(resultValue, mediaType, this.cursorProviderFactory, event, this.returnHandler.getDataType()) : MessageUtils.toMessage(resultValue, mediaType, this.cursorProviderFactory, event);
        }
        if (value instanceof Collection && this.returnsListOfMessages) {
            value = MessageUtils.toMessageCollection((Collection)((Object)value), this.cursorProviderFactory, ((BaseEventContext)event.getContext()).getRootContext());
        } else if (value instanceof Iterator && this.returnsListOfMessages) {
            value = MessageUtils.toMessageIterator((Iterator<Result>)value, this.cursorProviderFactory, ((BaseEventContext)event.getContext()).getRootContext());
        }
        value = this.streamingContent(value, operationContext, this.cursorProviderFactory, ((BaseEventContext)event.getContext()).getRootContext());
        Message.Builder messageBuilder = this.returnsListOfMessages && value instanceof Collection ? Message.builder().collectionValue((Collection)((Object)value), Message.class) : (this.isSpecialHandling && this.returnHandler.handles(value) ? this.returnHandler.toMessageBuilder(value) : Message.builder().value(value));
        return messageBuilder.mediaType(mediaType).build();
    }

    private Optional<MediaType> getContextMimeType(Map<String, Object> params) {
        return Optional.ofNullable((String)params.get("outputMimeType")).map(mimeType -> MediaType.parse(mimeType));
    }

    private Optional<Charset> getContextEncoding(Map<String, Object> params) {
        return Optional.ofNullable((String)params.get("outputEncoding")).map(encoding -> MediaTypeUtils.parseCharset(encoding));
    }

    private Object streamingContent(Object value, ExecutionContextAdapter operationContext, CursorProviderFactory cursorProviderFactory, BaseEventContext eventContext) {
        ConnectionHandler connectionHandler;
        if (value instanceof InputStream && (connectionHandler = (ConnectionHandler)operationContext.getVariable("MULE_CONNECTION_PARAM")) != null && StreamingUtils.supportsStreaming(operationContext.getComponentModel())) {
            value = new ConnectedInputStreamWrapper((InputStream)value, connectionHandler);
        }
        return StreamingUtils.streamingContent(value, cursorProviderFactory, eventContext);
    }

    protected MediaType resolveMediaType(Object value, Optional<MediaType> contextMimeType, Optional<Charset> contextEncoding) {
        Optional<MediaType> optionalMediaType;
        Charset existingEncoding = this.defaultEncoding;
        MediaType mediaType = this.defaultMediaType;
        if (value instanceof Result && (optionalMediaType = ((Result)value).getMediaType()).isPresent() && (mediaType = optionalMediaType.get()).getCharset().isPresent()) {
            existingEncoding = mediaType.getCharset().orElse(existingEncoding);
        }
        return contextMimeType.orElse(mediaType).withCharset(contextEncoding.orElse(existingEncoding));
    }

    private class ConnectedInputStreamWrapper
    extends InputStream {
        private final InputStream delegate;
        private final ConnectionHandler<?> connectionHandler;

        private ConnectedInputStreamWrapper(InputStream delegate, ConnectionHandler<?> connectionHandler) {
            this.delegate = delegate;
            this.connectionHandler = connectionHandler;
        }

        @Override
        public int read() throws IOException {
            return this.delegate.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
            }
            finally {
                this.connectionHandler.release();
            }
        }

        @Override
        public void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }
    }
}

