/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.io;

import java.io.File;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.io.Path;
import scala.reflect.io.Path$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class FileHelper$ {
    public static FileHelper$ MODULE$;
    private final Logger org$mule$weave$v2$io$FileHelper$$logger;
    private final File tmpdir;
    private final SecureRandom random;
    private final ExecutorService scheduler;

    static {
        new FileHelper$();
    }

    public Logger org$mule$weave$v2$io$FileHelper$$logger() {
        return this.org$mule$weave$v2$io$FileHelper$$logger;
    }

    public File tmpdir() {
        return this.tmpdir;
    }

    public SecureRandom random() {
        return this.random;
    }

    public ExecutorService scheduler() {
        return this.scheduler;
    }

    public File createTempFile(String prefix, String suffix) {
        long n = this.random().nextLong();
        n = n == Long.MIN_VALUE ? 0L : Math.abs(n);
        if (!this.tmpdir().exists()) {
            throw new RuntimeException("The specified temporary " + this.tmpdir().getAbsolutePath() + " directory does not exits. Please create the directory or provide a different one.");
        }
        return new File(this.tmpdir(), prefix + n + suffix);
    }

    public void deleteAsync(File tmp) {
        this.scheduler().submit(new Runnable(tmp){
            private final File tmp$1;

            public void run() {
                block0: {
                    boolean deleted;
                    if (!this.tmp$1.exists() || (deleted = this.tmp$1.delete()) || !this.tmp$1.exists()) break block0;
                    FileHelper$.MODULE$.org$mule$weave$v2$io$FileHelper$$logger().log(Level.WARNING, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to async delete ", ", it may be locked someone else."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tmp$1.getAbsolutePath()})));
                }
            }
            {
                this.tmp$1 = tmp$1;
            }
        });
    }

    public void deleteDirectory(File folder) {
        Path path = Path$.MODULE$.apply(folder);
        Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> path.deleteRecursively());
    }

    public String baseName(File x) {
        String fileName = x.getName();
        return x.isDirectory() ? fileName : this.baseName(fileName);
    }

    public String baseName(String fileName) {
        return fileName.contains(".") ? fileName.substring(0, fileName.lastIndexOf(".")) : fileName;
    }

    public String getExtension(File output) {
        String name = output.getName();
        return (String)this.getExtension(name).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    public Option<String> getExtension(String name) {
        return name.lastIndexOf(46) >= 0 ? new Some(new StringOps(Predef$.MODULE$.augmentString(name)).drop(name.lastIndexOf(46))) : None$.MODULE$;
    }

    public File createBufferFile(String name) {
        return this.createTempFile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dw-buffer-", "-"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), ".tmp");
    }

    private FileHelper$() {
        MODULE$ = this;
        this.org$mule$weave$v2$io$FileHelper$$logger = Logger.getLogger(this.getClass().getName());
        this.tmpdir = new File(System.getProperty("java.io.tmpdir"));
        this.random = new SecureRandom();
        this.scheduler = Executors.newFixedThreadPool(10, new ThreadFactory(){
            private final AtomicLong counter;

            private AtomicLong counter() {
                return this.counter;
            }

            /*
             * WARNING - void declaration
             */
            public Thread newThread(Runnable r) {
                void var2_2;
                Thread thread = new Thread(r, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Weave_File_Deleter_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.counter().getAndDecrement())})));
                thread.setDaemon(true);
                return var2_2;
            }
            {
                this.counter = new AtomicLong(1L);
            }
        });
    }
}

