/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ResourceUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class MuleCustomEntityResolver
implements EntityResolver {
    public static final String CUSTOM_SCHEMA_MAPPINGS_LOCATION = "META-INF/mule.schemas";
    public static final String CUSTOM_SPRING_SCHEMA_MAPPINGS_LOCATION = "META-INF/spring.schemas";
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleCustomEntityResolver.class);
    private final ClassLoader classLoader;
    private final Map<String, String> muleSchemaMappings;
    private final Map<String, String> appPluginsSchemaMappings;

    MuleCustomEntityResolver(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.muleSchemaMappings = this.getMuleSchemaMappings();
        this.appPluginsSchemaMappings = this.getAppPluginsSchemaMappings();
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        if (systemId != null) {
            InputSource source = MuleCustomEntityResolver.resoveEntityInClassloader(this.muleSchemaMappings, publicId, systemId, MuleCustomEntityResolver.class.getClassLoader());
            if (source == null) {
                source = MuleCustomEntityResolver.resoveEntityInClassloader(this.appPluginsSchemaMappings, publicId, systemId, this.classLoader);
            }
            return source;
        }
        return null;
    }

    private static InputSource resoveEntityInClassloader(Map<String, String> schemaMappings, String publicId, String systemId, ClassLoader cl) {
        String resourceLocation;
        if (systemId.startsWith("http://www.springframework.org/") && systemId.endsWith("-current.xsd")) {
            LOGGER.warn("Usage of `-current` spring schemas is discouraged, since it may lead to unexpected changes if the Spring version is upgraded. Schema found: " + systemId);
        }
        if ((resourceLocation = schemaMappings.get(systemId)) != null) {
            InputStream is = cl.getResourceAsStream(resourceLocation);
            if (is == null) {
                LOGGER.debug("Couldn't find XML schema [" + systemId + "]: " + resourceLocation);
                return null;
            }
            InputSource source = new InputSource(is);
            source.setPublicId(publicId);
            source.setSystemId(systemId);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found XML schema [" + systemId + "] in classpath: " + resourceLocation);
            }
            return source;
        }
        return null;
    }

    private Map<String, String> getMuleSchemaMappings() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Loading schema mappings from [META-INF/mule.schemas]");
        }
        try {
            Properties muleMappings = MuleCustomEntityResolver.loadAllProperties(CUSTOM_SCHEMA_MAPPINGS_LOCATION, MuleCustomEntityResolver.class.getClassLoader());
            Properties springMappings = MuleCustomEntityResolver.loadAllProperties(CUSTOM_SPRING_SCHEMA_MAPPINGS_LOCATION, MuleCustomEntityResolver.class.getClassLoader());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Loaded Mule schema mappings: " + muleMappings);
                LOGGER.debug("Loaded Spring schema mappings: " + springMappings);
            }
            HashMap<String, String> schemaMappings = new HashMap<String, String>(muleMappings.size(), springMappings.size());
            CollectionUtils.mergePropertiesIntoMap((Properties)muleMappings, schemaMappings);
            CollectionUtils.mergePropertiesIntoMap((Properties)springMappings, schemaMappings);
            return schemaMappings;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to load schema mappings from location [META-INF/mule.schemas]", ex);
        }
    }

    private Map<String, String> getAppPluginsSchemaMappings() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Loading schema mappings from [META-INF/mule.schemas]");
        }
        try {
            Properties appPluginsMappings = MuleCustomEntityResolver.loadAllProperties(CUSTOM_SCHEMA_MAPPINGS_LOCATION, this.classLoader);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Loaded App Plugins schema mappings: " + appPluginsMappings);
            }
            HashMap<String, String> schemaMappings = new HashMap<String, String>(appPluginsMappings.size());
            CollectionUtils.mergePropertiesIntoMap((Properties)appPluginsMappings, schemaMappings);
            return schemaMappings;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to load schema mappings from location [META-INF/mule.schemas]", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadAllProperties(String resourceName, ClassLoader classLoader) throws IOException {
        Assert.notNull((Object)resourceName, (String)"Resource name must not be null");
        ClassLoader classLoaderToUse = classLoader;
        if (classLoaderToUse == null) {
            classLoaderToUse = ClassUtils.getDefaultClassLoader();
        }
        Enumeration<URL> urls = classLoaderToUse != null ? classLoaderToUse.getResources(resourceName) : ClassLoader.getSystemResources(resourceName);
        Properties props = new Properties();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            URLConnection con = url.openConnection();
            ResourceUtils.useCachesIfNecessary((URLConnection)con);
            try (InputStream is = con.getInputStream();){
                if (resourceName != null && resourceName.endsWith(".xml")) {
                    props.loadFromXML(is);
                    continue;
                }
                props.load(is);
            }
        }
        return props;
    }
}

