/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.policy.OperationPolicyParametersTransformer;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.policy.AbstractCompositePolicy;
import org.mule.runtime.core.internal.policy.OperationExecutionFunction;
import org.mule.runtime.core.internal.policy.OperationParametersProcessor;
import org.mule.runtime.core.internal.policy.OperationPolicy;
import org.mule.runtime.core.internal.policy.OperationPolicyProcessorFactory;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class CompositeOperationPolicy
extends AbstractCompositePolicy<OperationPolicyParametersTransformer, OperationParametersProcessor>
implements OperationPolicy {
    private final Processor nextOperation;
    private final OperationPolicyProcessorFactory operationPolicyProcessorFactory;
    private CoreEvent nextOperationResponse;

    public CompositeOperationPolicy(List<Policy> parameterizedPolicies, final Optional<OperationPolicyParametersTransformer> operationPolicyParametersTransformer, OperationPolicyProcessorFactory operationPolicyProcessorFactory, final OperationParametersProcessor operationParametersProcessor, final OperationExecutionFunction operationExecutionFunction) {
        super(parameterizedPolicies, operationPolicyParametersTransformer, operationParametersProcessor);
        this.nextOperation = new Processor(){

            @Override
            public CoreEvent process(CoreEvent event) throws MuleException {
                return MessageProcessors.processToApply(event, this);
            }

            @Override
            public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
                return Mono.from(publisher).flatMap(event -> {
                    HashMap<String, Object> parametersMap = new HashMap<String, Object>();
                    try {
                        parametersMap.putAll(operationParametersProcessor.getOperationParameters());
                    }
                    catch (Exception e) {
                        return Mono.error(e);
                    }
                    if (operationPolicyParametersTransformer.isPresent()) {
                        parametersMap.putAll(((OperationPolicyParametersTransformer)operationPolicyParametersTransformer.get()).fromMessageToParameters(event.getMessage()));
                    }
                    return Mono.from(operationExecutionFunction.execute((Map<String, Object>)parametersMap, (CoreEvent)event));
                });
            }
        };
        this.operationPolicyProcessorFactory = operationPolicyProcessorFactory;
    }

    @Override
    protected Publisher<CoreEvent> processNextOperation(CoreEvent event, OperationParametersProcessor parametersProcessor) {
        return Mono.just(event).transform(this.nextOperation).doOnNext(response -> {
            this.nextOperationResponse = response;
        });
    }

    @Override
    protected Publisher<CoreEvent> processPolicy(Policy policy, Processor nextProcessor, CoreEvent event) {
        if (this.nextOperationResponse == null) {
            this.nextOperationResponse = event;
        }
        Processor defaultOperationPolicy = this.operationPolicyProcessorFactory.createOperationPolicy(policy, nextProcessor);
        return Mono.just(event).transform(defaultOperationPolicy).map(policyResponse -> {
            if (policy.getPolicyChain().isPropagateMessageTransformations()) {
                this.nextOperationResponse = policyResponse;
                return policyResponse;
            }
            return this.nextOperationResponse;
        });
    }

    @Override
    public Publisher<CoreEvent> process(CoreEvent operationEvent, OperationParametersProcessor parametersProcessor) {
        try {
            if (this.getParametersTransformer().isPresent()) {
                return MessageProcessors.processWithChildContext(CoreEvent.builder(operationEvent).message(((OperationPolicyParametersTransformer)this.getParametersTransformer().get()).fromParametersToMessage(parametersProcessor.getOperationParameters())).build(), this.getPolicyProcessor(), Optional.empty());
            }
            return MessageProcessors.processWithChildContext(operationEvent, this.getPolicyProcessor(), Optional.empty());
        }
        catch (Exception e) {
            return Mono.error(e);
        }
    }

    @FunctionalInterface
    private static interface OperationPolicyNextProcessor
    extends Processor {
        @Override
        default public CoreEvent process(CoreEvent event) throws MuleException {
            return MessageProcessors.processToApply(event, this);
        }

        @Override
        public Publisher<CoreEvent> apply(Publisher<CoreEvent> var1);
    }
}

