/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.policy.PolicyChain;
import org.mule.runtime.core.api.policy.PolicyStateHandler;
import org.mule.runtime.core.api.policy.PolicyStateId;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.policy.PolicyEventConverter;
import org.mule.runtime.core.internal.policy.PolicyStateIdFactory;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class OperationPolicyProcessor
implements Processor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationPolicyProcessor.class);
    private final Policy policy;
    private final PolicyStateHandler policyStateHandler;
    private final PolicyEventConverter policyEventConverter = new PolicyEventConverter();
    private final Processor nextProcessor;
    private final PolicyStateIdFactory stateIdFactory;

    public OperationPolicyProcessor(Policy policy, PolicyStateHandler policyStateHandler, Processor nextProcessor) {
        this.policy = policy;
        this.policyStateHandler = policyStateHandler;
        this.nextProcessor = nextProcessor;
        this.stateIdFactory = new PolicyStateIdFactory(policy.getPolicyId());
    }

    @Override
    public CoreEvent process(CoreEvent operationEvent) throws MuleException {
        return MessageProcessors.processToApply(operationEvent, this);
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Mono.from(publisher).cast(PrivilegedEvent.class).flatMap(operationEvent -> {
            PolicyStateId policyStateId = this.stateIdFactory.create((CoreEvent)operationEvent);
            PrivilegedEvent variablesProviderEvent = this.variablesProvider((CoreEvent)operationEvent, policyStateId);
            PrivilegedEvent policyEvent = this.policyEventConverter.createEvent((PrivilegedEvent)operationEvent, variablesProviderEvent);
            Processor operationCall = this.buildOperationExecutionWithPolicyFunction(this.nextProcessor, (PrivilegedEvent)operationEvent, policyStateId);
            return this.executePolicyChain((PrivilegedEvent)operationEvent, policyStateId, policyEvent, operationCall);
        });
    }

    private void manageError(PolicyStateId policyStateId, PrivilegedEvent operationEvent, MessagingException messagingException) {
        this.policyStateHandler.updateState(policyStateId, messagingException.getEvent());
        PrivilegedEvent newEvent = this.policyEventConverter.createEvent((PrivilegedEvent)messagingException.getEvent(), operationEvent);
        messagingException.setProcessedEvent(newEvent);
    }

    private Mono<PrivilegedEvent> executePolicyChain(PrivilegedEvent operationEvent, PolicyStateId policyStateId, PrivilegedEvent policyEvent, Processor nextProcessor) {
        PolicyChain policyChain = this.policy.getPolicyChain();
        policyChain.onChainError(t -> this.manageError(policyStateId, operationEvent, (MessagingException)t));
        return Mono.just(policyEvent).doOnNext(event -> this.logPolicy(event.getContext().getCorrelationId(), policyStateId.getPolicyId(), () -> this.getMessageAttributesAsString((CoreEvent)event), "Before operation")).cast(CoreEvent.class).transform(policyChain).cast(PrivilegedEvent.class).doOnNext(policyChainResult -> this.policyStateHandler.updateState(policyStateId, (CoreEvent)policyChainResult)).map(policyChainResult -> this.policyEventConverter.createEvent((PrivilegedEvent)policyChainResult, operationEvent)).doOnNext(event -> this.logPolicy(event.getContext().getCorrelationId(), policyStateId.getPolicyId(), () -> this.getMessageAttributesAsString((CoreEvent)event), "After operation")).subscriberContext(ctx -> ctx.put("policy.nextOperation", nextProcessor));
    }

    private Processor buildOperationExecutionWithPolicyFunction(final Processor nextOperation, final PrivilegedEvent operationEvent, final PolicyStateId policyStateId) {
        return new Processor(){

            @Override
            public CoreEvent process(CoreEvent event) throws MuleException {
                return MessageProcessors.processToApply(event, this);
            }

            @Override
            public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
                return Mono.from(publisher).cast(PrivilegedEvent.class).flatMap(policyExecuteNextEvent -> {
                    OperationPolicyProcessor.this.policyStateHandler.updateState(policyStateId, (CoreEvent)policyExecuteNextEvent);
                    return Mono.just(policyExecuteNextEvent).map(event -> OperationPolicyProcessor.this.policyEventConverter.createEvent((PrivilegedEvent)event, operationEvent)).cast(CoreEvent.class).transform(nextOperation).cast(PrivilegedEvent.class).map(operationResult -> OperationPolicyProcessor.this.policyEventConverter.createEvent((PrivilegedEvent)operationResult, (PrivilegedEvent)policyExecuteNextEvent));
                });
            }
        };
    }

    private PrivilegedEvent variablesProvider(CoreEvent event, PolicyStateId policyStateId) {
        Optional<CoreEvent> latestPolicyState = this.policyStateHandler.getLatestState(policyStateId);
        return (PrivilegedEvent)latestPolicyState.orElseGet(() -> PrivilegedEvent.builder(event.getContext()).message(Message.of(null)).build());
    }

    private String getMessageAttributesAsString(CoreEvent event) {
        if (event.getMessage() == null || event.getMessage().getAttributes() == null || event.getMessage().getAttributes().getValue() == null) {
            return "";
        }
        return event.getMessage().getAttributes().getValue().toString();
    }

    private void logPolicy(String eventId, String policyName, Supplier<String> message, String startingMessage) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Event Id: " + eventId + ".\n" + startingMessage + "\nPolicy:" + policyName + "\n" + message.get());
        }
    }
}

