/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor;

import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class LoggingExceptionHandler
implements FlowExceptionHandler {
    private static final LoggingExceptionHandler INSTANCE = new LoggingExceptionHandler();
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingExceptionHandler.class);

    private LoggingExceptionHandler() {
    }

    public static FlowExceptionHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public CoreEvent handleException(Exception exception, CoreEvent event) {
        this.onError(exception);
        throw new RuntimeException(exception);
    }

    @Override
    public Publisher<CoreEvent> apply(Exception exception) {
        this.onError(exception);
        return Mono.error(exception);
    }

    private void onError(Exception exception) {
        MuleException me = ExceptionHelper.getRootMuleException(exception);
        if (me != null) {
            LOGGER.error(me.getDetailedMessage());
        } else {
            LOGGER.error("'{}: {}' has occurred.", new Object[]{exception.getClass().getName(), exception.getMessage(), exception});
        }
    }
}

