/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.interceptor;

import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.interception.InterceptionAction;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.interception.DefaultInterceptionEvent;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.processor.interceptor.InterceptionException;
import org.mule.runtime.core.internal.util.InternalExceptionUtils;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

class ReactiveInterceptionAction
implements InterceptionAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveInterceptionAction.class);
    private ErrorTypeLocator errorTypeLocator;
    private Processor processor;
    private ReactiveProcessor next;
    private DefaultInterceptionEvent interceptionEvent;

    public ReactiveInterceptionAction(DefaultInterceptionEvent interceptionEvent, ReactiveProcessor next, Processor processor, ErrorTypeLocator errorTypeLocator) {
        this.interceptionEvent = interceptionEvent;
        this.next = next;
        this.processor = processor;
        this.errorTypeLocator = errorTypeLocator;
    }

    @Override
    public CompletableFuture<InterceptionEvent> proceed() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Called proceed() for processor {}", (Object)((Component)((Object)this.processor)).getLocation().getLocation());
        }
        return Mono.just(this.interceptionEvent.resolve()).cast(CoreEvent.class).transform(this.next).cast(InternalEvent.class).map(event -> {
            this.interceptionEvent.reset((InternalEvent)event);
            return this.interceptionEvent;
        }).cast(InterceptionEvent.class).toFuture();
    }

    @Override
    public CompletableFuture<InterceptionEvent> skip() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Called skip() for processor {}", (Object)((Component)((Object)this.processor)).getLocation().getLocation());
        }
        this.interceptionEvent.resolve();
        return CompletableFuture.completedFuture(this.interceptionEvent);
    }

    @Override
    public CompletableFuture<InterceptionEvent> fail(Throwable cause) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Called fail() for processor {} with cause {} ({})", new Object[]{((Component)((Object)this.processor)).getLocation().getLocation(), cause.getClass(), cause.getMessage()});
        }
        Error newError = InternalExceptionUtils.getErrorFromFailingProcessor(null, (Component)((Object)this.processor), cause, this.errorTypeLocator);
        this.interceptionEvent.setError(newError.getErrorType(), cause);
        CompletableFuture<InterceptionEvent> completableFuture = new CompletableFuture<InterceptionEvent>();
        completableFuture.completeExceptionally(new MessagingException(this.interceptionEvent.resolve(), cause, (Component)((Object)this.processor)));
        return completableFuture;
    }

    @Override
    public CompletableFuture<InterceptionEvent> fail(ErrorType errorType) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Called fail() for processor {} with errorType {}", (Object)((Component)((Object)this.processor)).getLocation().getLocation(), (Object)errorType.getIdentifier());
        }
        InterceptionException cause = new InterceptionException("");
        this.interceptionEvent.setError(errorType, cause);
        CompletableFuture<InterceptionEvent> completableFuture = new CompletableFuture<InterceptionEvent>();
        completableFuture.completeExceptionally(new MessagingException(this.interceptionEvent.resolve(), cause, (Component)((Object)this.processor)));
        return completableFuture;
    }
}

