/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.server;

import java.util.function.Supplier;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.util.Preconditions;

public class HttpServerConfiguration {
    private final String host;
    private final int port;
    private final TlsContextFactory tlsContextFactory;
    private final boolean usePersistentConnections;
    private final int connectionIdleTimeout;
    private final String name;
    private final Supplier<Scheduler> schedulerSupplier;

    HttpServerConfiguration(String host, int port, TlsContextFactory tlsContextFactory, boolean usePersistentConnections, int connectionIdleTimeout, String name, Supplier<Scheduler> schedulerSupplier) {
        this.host = host;
        this.port = port;
        this.tlsContextFactory = tlsContextFactory;
        this.usePersistentConnections = usePersistentConnections;
        this.connectionIdleTimeout = connectionIdleTimeout;
        this.name = name;
        this.schedulerSupplier = schedulerSupplier;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public TlsContextFactory getTlsContextFactory() {
        return this.tlsContextFactory;
    }

    public boolean isUsePersistentConnections() {
        return this.usePersistentConnections;
    }

    public int getConnectionIdleTimeout() {
        return this.connectionIdleTimeout;
    }

    public String getName() {
        return this.name;
    }

    public Supplier<Scheduler> getSchedulerSupplier() {
        return this.schedulerSupplier;
    }

    public static class Builder {
        private String host;
        private int port;
        private TlsContextFactory tlsContextFactory;
        private boolean usePersistentConnections = true;
        private int connectionIdleTimeout = 30000;
        private Supplier<Scheduler> schedulerSupplier;
        private String name;

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setTlsContextFactory(TlsContextFactory tlsContextFactory) {
            this.tlsContextFactory = tlsContextFactory;
            return this;
        }

        public Builder setUsePersistentConnections(boolean usePersistentConnections) {
            this.usePersistentConnections = usePersistentConnections;
            return this;
        }

        public Builder setConnectionIdleTimeout(int connectionIdleTimeout) {
            this.connectionIdleTimeout = connectionIdleTimeout;
            return this;
        }

        public Builder setSchedulerSupplier(Supplier<Scheduler> schedulerSupplier) {
            this.schedulerSupplier = schedulerSupplier;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public HttpServerConfiguration build() {
            Preconditions.checkNotNull(this.host, "A host is mandatory");
            Preconditions.checkNotNull(this.port, "Port is mandatory");
            Preconditions.checkNotNull(this.name, "Name is mandatory");
            return new HttpServerConfiguration(this.host, this.port, this.tlsContextFactory, this.usePersistentConnections, this.connectionIdleTimeout, this.name, this.schedulerSupplier);
        }
    }
}

