/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.config;

import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.runtime.ExpirationPolicy;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionDefinitionParser;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionParsingContext;
import org.mule.runtime.module.extension.internal.config.dsl.config.ConfigurationProviderObjectFactory;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderResolver;

public final class ConfigurationDefinitionParser
extends ExtensionDefinitionParser {
    private final ExtensionModel extensionModel;
    private final ConfigurationModel configurationModel;
    private final DslElementSyntax configDsl;

    public ConfigurationDefinitionParser(ComponentBuildingDefinition.Builder definition, ExtensionModel extensionModel, ConfigurationModel configurationModel, DslSyntaxResolver dslResolver, ExtensionParsingContext parsingContext) {
        super(definition, dslResolver, parsingContext);
        this.extensionModel = extensionModel;
        this.configurationModel = configurationModel;
        this.configDsl = dslResolver.resolve(configurationModel);
    }

    @Override
    protected ComponentBuildingDefinition.Builder doParse(ComponentBuildingDefinition.Builder definitionBuilder) throws ConfigurationException {
        ComponentBuildingDefinition.Builder finalBuilder = definitionBuilder.withIdentifier(this.configDsl.getElementName()).withTypeDefinition(TypeDefinition.fromType(ConfigurationProvider.class)).withObjectFactoryType(ConfigurationProviderObjectFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter("name").build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue(this.extensionModel).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue(this.configurationModel).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromReferenceObject(MuleContext.class).build()).withSetterParameterDefinition("expirationPolicy", AttributeDefinition.Builder.fromChildConfiguration(ExpirationPolicy.class).build());
        this.parseParameters(this.configurationModel);
        finalBuilder = this.parseConnectionProvider(finalBuilder);
        return finalBuilder;
    }

    private ComponentBuildingDefinition.Builder parseConnectionProvider(ComponentBuildingDefinition.Builder definitionBuilder) {
        if (ExtensionModelUtils.supportsConnectivity(this.extensionModel, this.configurationModel)) {
            return definitionBuilder.withSetterParameterDefinition("requiresConnection", AttributeDefinition.Builder.fromFixedValue(true).build()).withSetterParameterDefinition("connectionProviderResolver", AttributeDefinition.Builder.fromChildConfiguration(ConnectionProviderResolver.class).build());
        }
        return definitionBuilder;
    }
}

