/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.util.Map;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

final class ReflectiveExecutorFactoryUtil {
    private ReflectiveExecutorFactoryUtil() {
    }

    static Object createDelegate(Class<?> methodOwnerClass, Map<String, Object> parameters) {
        Object delegate;
        DefaultObjectBuilder objectBuilder = new DefaultObjectBuilder(methodOwnerClass, new ReflectionCache());
        parameters.forEach((k, v) -> objectBuilder.addPropertyResolver((String)k, (ValueResolver<Object>)new StaticValueResolver<Object>(v)));
        CoreEvent initialiserEvent = null;
        try {
            initialiserEvent = MuleExtensionUtils.getInitialiserEvent();
            delegate = objectBuilder.build(ValueResolvingContext.from(initialiserEvent));
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not create instance of operation class " + methodOwnerClass.getName()), (Throwable)e);
        }
        finally {
            if (initialiserEvent != null) {
                ((BaseEventContext)initialiserEvent.getContext()).success();
            }
        }
        return delegate;
    }
}

