/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.streaming;

import java.util.List;
import java.util.function.Function;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.streaming.iterator.Producer;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.api.util.func.CheckedSupplier;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;
import org.mule.runtime.module.extension.internal.runtime.streaming.PagingProviderWrapper;
import org.mule.runtime.module.extension.internal.runtime.transaction.ExtensionTransactionKey;

public final class PagingProviderProducer<T>
implements Producer<List<T>> {
    private static final String PAGE_ERROR = "An error occurred trying to obtain a Page";
    private static final String COULD_NOT_OBTAIN_A_CONNECTION = "Could not obtain a connection for the configuration";
    private PagingProvider<Object, T> delegate;
    private final ConfigurationInstance config;
    private final ExtensionConnectionSupplier connectionSupplier;
    private final ExecutionContextAdapter executionContext;
    private final ConnectionSupplierFactory connectionSupplierFactory;

    public PagingProviderProducer(PagingProvider<Object, T> delegate, ConfigurationInstance config, ExecutionContextAdapter executionContext, ExtensionConnectionSupplier connectionSupplier) {
        this.delegate = new PagingProviderWrapper<Object, T>(delegate, executionContext.getExtensionModel());
        this.config = config;
        this.executionContext = executionContext;
        this.connectionSupplier = connectionSupplier;
        this.connectionSupplierFactory = this.createConnectionSupplierFactory();
    }

    @Override
    public List<T> produce() {
        return this.performWithConnection(connection -> this.delegate.getPage(connection));
    }

    @Override
    public int getSize() {
        return this.performWithConnection(connection -> this.delegate.getTotalResults(connection)).orElse(-1);
    }

    private <R> R performWithConnection(Function<Object, R> function) {
        try (ConnectionSupplier connectionSupplier = null;){
            connectionSupplier = this.connectionSupplierFactory.getConnectionSupplier();
            this.executionContext.setVariable("MULE_CONNECTION_PARAM", connectionSupplier.getHandler());
            R r = function.apply(connectionSupplier.getConnection());
            return r;
        }
    }

    @Override
    public void close() {
        ConnectionSupplier connectionSupplier = null;
        try {
            connectionSupplier = this.connectionSupplierFactory.getConnectionSupplier();
            this.delegate.close(connectionSupplier.getConnection());
        }
        catch (Exception e) {
            throw new PagingProviderRuntimeException(I18nMessageFactory.createStaticMessage(COULD_NOT_OBTAIN_A_CONNECTION), (Throwable)e);
        }
        finally {
            if (connectionSupplier != null) {
                connectionSupplier.close();
            }
            this.connectionSupplierFactory.dispose();
        }
    }

    private ConnectionSupplierFactory createConnectionSupplierFactory() {
        if (this.delegate.useStickyConnections() || this.isTransactional()) {
            return new StickyConnectionSupplierFactory();
        }
        return new DefaultConnectionSupplierFactory();
    }

    private boolean isTransactional() {
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        return tx != null && tx.hasResource(new ExtensionTransactionKey(this.config));
    }

    public Throwable getCause(Throwable t) {
        if (t instanceof PagingProviderRuntimeException) {
            return t.getCause();
        }
        return t;
    }

    private static class PagingProviderRuntimeException
    extends MuleRuntimeException {
        PagingProviderRuntimeException(I18nMessage message, Throwable cause) {
            super(message, cause);
        }
    }

    private class StickyConnectionSupplier
    implements ConnectionSupplier {
        private final Object connection;
        private ConnectionHandler connectionHandler;

        public StickyConnectionSupplier(Object connection, ConnectionHandler connectionHandler) {
            this.connection = connection;
            this.connectionHandler = connectionHandler;
        }

        @Override
        public Object getConnection() throws MuleException {
            return this.connection;
        }

        @Override
        public ConnectionHandler getHandler() {
            return this.connectionHandler;
        }

        @Override
        public void close() {
        }

        @Override
        public void invalidate() {
            this.connectionHandler.invalidate();
        }
    }

    private class DefaultConnectionSupplier
    implements ConnectionSupplier {
        private final ConnectionHandler connectionHandler;

        public DefaultConnectionSupplier(ConnectionHandler connectionHandler) {
            this.connectionHandler = connectionHandler;
        }

        @Override
        public Object getConnection() throws MuleException {
            return this.connectionHandler.getConnection();
        }

        @Override
        public ConnectionHandler getHandler() {
            return this.connectionHandler;
        }

        @Override
        public void close() {
            this.connectionHandler.release();
        }

        @Override
        public void invalidate() {
            this.connectionHandler.invalidate();
        }
    }

    private static interface ConnectionSupplier {
        public Object getConnection() throws MuleException;

        public ConnectionHandler getHandler();

        public void close();

        public void invalidate();
    }

    private class StickyConnectionSupplierFactory
    implements ConnectionSupplierFactory {
        private final LazyValue<ConnectionSupplier> stickyConnection = new LazyValue<1>(new CheckedSupplier<ConnectionSupplier>(){

            @Override
            public ConnectionSupplier getChecked() throws Throwable {
                StickyConnectionSupplierFactory.this.connectionHandler = PagingProviderProducer.this.connectionSupplier.getConnection(PagingProviderProducer.this.executionContext);
                return new StickyConnectionSupplier(StickyConnectionSupplierFactory.this.connectionHandler.getConnection(), StickyConnectionSupplierFactory.this.connectionHandler);
            }
        });
        private ConnectionHandler connectionHandler;

        private StickyConnectionSupplierFactory() {
        }

        @Override
        public ConnectionSupplier getConnectionSupplier() {
            return this.stickyConnection.get();
        }

        @Override
        public void dispose() {
            if (this.connectionHandler != null) {
                this.connectionHandler.release();
            }
        }
    }

    private class DefaultConnectionSupplierFactory
    implements ConnectionSupplierFactory {
        private DefaultConnectionSupplierFactory() {
        }

        @Override
        public ConnectionSupplier getConnectionSupplier() throws MuleException {
            return new DefaultConnectionSupplier(PagingProviderProducer.this.connectionSupplier.getConnection(PagingProviderProducer.this.executionContext));
        }

        @Override
        public void dispose() {
        }
    }

    private static interface ConnectionSupplierFactory {
        public ConnectionSupplier getConnectionSupplier() throws MuleException;

        public void dispose();
    }
}

