/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.coreextension;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.service.ServiceRepository;
import org.mule.runtime.container.api.ArtifactClassLoaderManagerAware;
import org.mule.runtime.container.api.CoreExtensionsAware;
import org.mule.runtime.container.api.MuleCoreExtension;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.event.EventContextService;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderManager;
import org.mule.runtime.module.deployment.api.ArtifactDeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.DeploymentServiceAware;
import org.mule.runtime.module.deployment.internal.DeploymentListenerAdapter;
import org.mule.runtime.module.launcher.coreextension.ContainerInjectorBuilder;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionDependencyResolver;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionDiscoverer;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionManagerServer;
import org.mule.runtime.module.repository.api.RepositoryService;
import org.mule.runtime.module.repository.api.RepositoryServiceAware;
import org.mule.runtime.module.tooling.api.ToolingService;
import org.mule.runtime.module.tooling.api.ToolingServiceAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMuleCoreExtensionManagerServer
implements MuleCoreExtensionManagerServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMuleCoreExtensionManagerServer.class);
    private final MuleCoreExtensionDiscoverer coreExtensionDiscoverer;
    private final MuleCoreExtensionDependencyResolver coreExtensionDependencyResolver;
    private List<MuleCoreExtension> coreExtensions = new LinkedList<MuleCoreExtension>();
    private DeploymentService deploymentService;
    private RepositoryService repositoryService;
    private ToolingService toolingService;
    private List<MuleCoreExtension> orderedCoreExtensions;
    private ArtifactClassLoaderManager artifactClassLoaderManager;
    private ServiceRepository serviceRepository;
    private EventContextService eventContextService;
    private List<MuleCoreExtension> initializedCoreExtensions = new ArrayList<MuleCoreExtension>();
    private List<MuleCoreExtension> startedCoreExtensions = new ArrayList<MuleCoreExtension>();

    public DefaultMuleCoreExtensionManagerServer(MuleCoreExtensionDiscoverer coreExtensionDiscoverer, MuleCoreExtensionDependencyResolver coreExtensionDependencyResolver) {
        this.coreExtensionDiscoverer = coreExtensionDiscoverer;
        this.coreExtensionDependencyResolver = coreExtensionDependencyResolver;
    }

    @Override
    public void dispose() {
        LOGGER.info("Disposing core extensions");
        for (MuleCoreExtension extension : this.coreExtensions) {
            if (!this.initializedCoreExtensions.contains(extension)) continue;
            try {
                extension.dispose();
                LOGGER.info("Core extension '{}' disposed", (Object)extension.toString());
            }
            catch (Exception ex) {
                LOGGER.error("Error disposing core extension " + extension.getName(), (Throwable)ex);
            }
        }
        this.initializedCoreExtensions.clear();
    }

    @Override
    public void initialise() throws InitialisationException {
        try {
            this.coreExtensions = this.coreExtensionDiscoverer.discover();
            this.orderedCoreExtensions = this.coreExtensionDependencyResolver.resolveDependencies(this.coreExtensions);
            this.initializeCoreExtensions();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    @Override
    public void start() throws MuleException {
        LOGGER.info("Starting core extensions");
        for (MuleCoreExtension extension : this.orderedCoreExtensions) {
            extension.start();
            this.startedCoreExtensions.add(extension);
            LOGGER.info("Core extension '{}' started", (Object)extension.toString());
        }
    }

    @Override
    public void stop() throws MuleException {
        if (this.orderedCoreExtensions == null) {
            return;
        }
        LOGGER.info("Stopping core extensions");
        for (int i = this.orderedCoreExtensions.size() - 1; i >= 0; --i) {
            MuleCoreExtension extension = this.orderedCoreExtensions.get(i);
            if (!this.startedCoreExtensions.contains(extension)) continue;
            try {
                extension.stop();
                LOGGER.info("Core extension '{}' stopped", (Object)extension.toString());
                continue;
            }
            catch (Throwable e) {
                LOGGER.warn("Error stopping core extension: " + extension.getName(), e);
            }
        }
        this.startedCoreExtensions.clear();
    }

    private void initializeCoreExtensions() throws MuleException {
        LOGGER.info("Initializing core extensions");
        Injector simpleRegistry = this.createContainerInjector();
        for (MuleCoreExtension extension : this.orderedCoreExtensions) {
            if (extension instanceof DeploymentServiceAware) {
                ((DeploymentServiceAware)((Object)extension)).setDeploymentService(this.deploymentService);
            }
            if (extension instanceof RepositoryServiceAware) {
                ((RepositoryServiceAware)((Object)extension)).setRepositoryService(this.repositoryService);
            }
            if (extension instanceof ToolingServiceAware) {
                ((ToolingServiceAware)((Object)extension)).setToolingService(this.toolingService);
            }
            if (extension instanceof ArtifactDeploymentListener) {
                this.deploymentService.addDeploymentListener(this.createDeploymentListenerAdapter((ArtifactDeploymentListener)((Object)extension), ArtifactType.APP));
                this.deploymentService.addDomainDeploymentListener(this.createDeploymentListenerAdapter((ArtifactDeploymentListener)((Object)extension), ArtifactType.DOMAIN));
            }
            if (extension instanceof DeploymentListener) {
                this.deploymentService.addDeploymentListener((DeploymentListener)((Object)extension));
            }
            if (extension instanceof CoreExtensionsAware) {
                ((CoreExtensionsAware)((Object)extension)).setCoreExtensions(this.orderedCoreExtensions);
            }
            if (extension instanceof ArtifactClassLoaderManagerAware) {
                ((ArtifactClassLoaderManagerAware)((Object)extension)).setArtifactClassLoaderManager(this.artifactClassLoaderManager);
            }
            simpleRegistry.inject(extension);
            extension.initialise();
            this.initializedCoreExtensions.add(extension);
            LOGGER.info("Core extension '{}' initialized", (Object)extension.toString());
        }
    }

    private Injector createContainerInjector() {
        return ((ContainerInjectorBuilder)((ContainerInjectorBuilder)((ContainerInjectorBuilder)((ContainerInjectorBuilder)((ContainerInjectorBuilder)((ContainerInjectorBuilder)((ContainerInjectorBuilder)new ContainerInjectorBuilder().withDeploymentService(this.deploymentService)).withRepositoryService(this.repositoryService)).withServiceRepository(this.serviceRepository)).withCoreExtensions(this.coreExtensions)).withArtifactClassLoaderManager(this.artifactClassLoaderManager)).withEventContextService(this.eventContextService)).withToolingService(this.toolingService)).build();
    }

    @Override
    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    @Override
    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Override
    public void setToolingService(ToolingService toolingService) {
        this.toolingService = toolingService;
    }

    @Override
    public void setArtifactClassLoaderManager(ArtifactClassLoaderManager artifactClassLoaderManager) {
        this.artifactClassLoaderManager = artifactClassLoaderManager;
    }

    @Override
    public void setEventContextService(EventContextService eventContextService) {
        this.eventContextService = eventContextService;
    }

    @Override
    public void setServiceRepository(ServiceRepository serviceRepository) {
        this.serviceRepository = serviceRepository;
    }

    DeploymentListener createDeploymentListenerAdapter(ArtifactDeploymentListener artifactDeploymentListener, ArtifactType type) {
        return new DeploymentListenerAdapter(artifactDeploymentListener, type);
    }
}

