/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.config.internal.MuleCustomEntityResolver;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.ExtensionSchemaGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ModuleDelegatingEntityResolver
implements EntityResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleDelegatingEntityResolver.class);
    private static final String CORE_XSD = "http://www.mulesoft.org/schema/mule/core/current/mule.xsd";
    private static final String CORE_CURRENT_XSD = "http://www.mulesoft.org/schema/mule/core/current/mule-core.xsd";
    private static final String CORE_DEPRECATED_XSD = "http://www.mulesoft.org/schema/mule/core/current/mule-core-deprecated.xsd";
    private static final String COMPATIBILITY_XSD = "http://www.mulesoft.org/schema/mule/compatibility/current/mule-compatibility.xsd";
    private static final String TEST_XSD = "http://www.mulesoft.org/schema/mule/test/current/mule-test.xsd";
    private static Boolean internalIsRunningTests;
    private final Set<ExtensionModel> extensions;
    private final EntityResolver muleEntityResolver;
    private Optional<ExtensionSchemaGenerator> extensionSchemaFactory;
    private Map<String, Boolean> checkedEntities;

    public ModuleDelegatingEntityResolver(Set<ExtensionModel> extensions) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.muleEntityResolver = new MuleCustomEntityResolver(classLoader);
        this.extensions = extensions;
        this.checkedEntities = new HashMap<String, Boolean>();
        SpiServiceRegistry spiServiceRegistry = new SpiServiceRegistry();
        Collection<ExtensionSchemaGenerator> schemaResourceFactories = spiServiceRegistry.lookupProviders(ExtensionSchemaGenerator.class, this.getClass().getClassLoader());
        if (schemaResourceFactories.isEmpty()) {
            this.extensionSchemaFactory = Optional.empty();
        } else if (schemaResourceFactories.size() == 1) {
            this.extensionSchemaFactory = Optional.of(schemaResourceFactories.iterator().next());
        } else {
            throw new IllegalArgumentException(String.format("There are '%s' providers for '%s' when there must be 1 or zero.", schemaResourceFactories.size(), ExtensionSchemaGenerator.class.getName()));
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource inputSource;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Looking schema for public identifier(publicId): '%s', system identifier(systemId): '%s'", publicId == null ? "" : publicId, systemId));
        }
        if ((inputSource = this.muleEntityResolver.resolveEntity(publicId, systemId = this.overrideSystemIdForCompatibility(publicId, systemId))) == null) {
            inputSource = this.generateFromExtensions(publicId, systemId);
        }
        if (inputSource == null) {
            if (this.checkedEntities.get(systemId) != null) {
                String namespaceNotFound = publicId == null ? String.format("Can't resolve %s", systemId) : String.format("Can't resolve %s (%s)", publicId, systemId);
                String message = String.format("%s, A dependency or plugin might be missing", namespaceNotFound);
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(message));
            }
            this.checkedEntities.put(systemId, true);
        }
        return inputSource;
    }

    private String overrideSystemIdForCompatibility(String publicId, String systemId) throws SAXException, IOException {
        boolean runningTests;
        if (systemId.equals(CORE_XSD)) {
            Boolean useDeprecated = this.canResolveEntity(publicId, CORE_DEPRECATED_XSD);
            Boolean usingCompatibility = this.canResolveEntity(publicId, COMPATIBILITY_XSD);
            boolean runningTests2 = this.isRunningTests();
            if (useDeprecated.booleanValue() && (usingCompatibility.booleanValue() || runningTests2)) {
                return CORE_DEPRECATED_XSD;
            }
            return CORE_CURRENT_XSD;
        }
        if (systemId.equals(TEST_XSD) && !(runningTests = this.isRunningTests()) && this.generateFromExtensions(publicId, systemId) == null) {
            String message = "Internal runtime mule-test.xsd can't be used in real applications";
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(message));
        }
        return systemId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean canResolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource resolvedEntity = this.muleEntityResolver.resolveEntity(publicId, systemId);
        try {
            boolean bl = resolvedEntity != null;
            return bl;
        }
        finally {
            if (resolvedEntity != null) {
                if (resolvedEntity.getByteStream() != null) {
                    resolvedEntity.getByteStream().close();
                }
                if (resolvedEntity.getCharacterStream() != null) {
                    resolvedEntity.getCharacterStream().close();
                }
            }
        }
    }

    private boolean isRunningTests() {
        if (internalIsRunningTests != null) {
            return internalIsRunningTests;
        }
        for (StackTraceElement element : new Throwable().getStackTrace()) {
            if (!element.getClassName().startsWith("org.junit.runners.")) continue;
            internalIsRunningTests = true;
            return true;
        }
        internalIsRunningTests = false;
        return false;
    }

    private InputSource generateFromExtensions(String publicId, String systemId) {
        Optional<ExtensionModel> extensionModel;
        InputSource inputSource = null;
        if (this.extensionSchemaFactory.isPresent() && (extensionModel = this.extensions.stream().filter(em -> systemId.equals(em.getXmlDslModel().getSchemaLocation())).findAny()).isPresent()) {
            InputStream schema = this.getSchemaFromExtension(extensionModel.get());
            inputSource = new InputSource(schema);
            inputSource.setPublicId(publicId);
            inputSource.setSystemId(systemId);
        }
        return inputSource;
    }

    private InputStream getSchemaFromExtension(ExtensionModel extensionModel) {
        String generatedResource = this.extensionSchemaFactory.map(f -> f.generate(extensionModel, DslResolvingContext.getDefault(this.extensions))).orElseThrow(() -> new IllegalStateException("There were no schema generators available when trying to work with the extension '" + extensionModel.getName() + "'"));
        return new ByteArrayInputStream(generatedResource.getBytes(StandardCharsets.UTF_8));
    }
}

