/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.lock;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import org.mule.runtime.core.internal.lock.LockGroup;
import org.mule.runtime.core.internal.lock.LockProvider;

public class InstanceLockGroup
implements LockGroup {
    private Map<String, LockEntry> locks;
    private Object lockAccessMonitor = new Object();
    private LockProvider lockProvider;

    public InstanceLockGroup(LockProvider lockProvider) {
        this.lockProvider = lockProvider;
        this.locks = new HashMap<String, LockEntry>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(String lockId) {
        LockEntry lockEntry;
        Object object = this.lockAccessMonitor;
        synchronized (object) {
            if (this.locks.containsKey(lockId)) {
                lockEntry = this.locks.get(lockId);
            } else {
                lockEntry = new LockEntry(this.lockProvider.createLock(lockId));
                this.locks.put(lockId, lockEntry);
            }
            lockEntry.incrementLockCount();
            this.lockAccessMonitor.notifyAll();
        }
        lockEntry.getLock().lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(String key) {
        Object object = this.lockAccessMonitor;
        synchronized (object) {
            LockEntry lockEntry = this.locks.get(key);
            if (lockEntry != null) {
                lockEntry.decrementLockCount();
                if (!lockEntry.hasPendingLocks()) {
                    this.locks.remove(key);
                }
                lockEntry.getLock().unlock();
            }
            this.lockAccessMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryLock(String lockId, long timeout, TimeUnit timeUnit) throws InterruptedException {
        LockEntry lockEntry;
        Object object = this.lockAccessMonitor;
        synchronized (object) {
            if (this.locks.containsKey(lockId)) {
                lockEntry = this.locks.get(lockId);
            } else {
                lockEntry = new LockEntry(this.lockProvider.createLock(lockId));
                this.locks.put(lockId, lockEntry);
            }
            lockEntry.incrementLockCount();
            this.lockAccessMonitor.notifyAll();
        }
        boolean lockAcquired = lockEntry.getLock().tryLock(timeout, timeUnit);
        if (!lockAcquired) {
            Object object2 = this.lockAccessMonitor;
            synchronized (object2) {
                lockEntry.decrementLockCount();
                if (!lockEntry.hasPendingLocks()) {
                    this.locks.remove(lockId);
                }
            }
        }
        return lockAcquired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryLock(String lockId) {
        LockEntry lockEntry;
        Object object = this.lockAccessMonitor;
        synchronized (object) {
            if (this.locks.containsKey(lockId)) {
                lockEntry = this.locks.get(lockId);
            } else {
                lockEntry = new LockEntry(this.lockProvider.createLock(lockId));
                this.locks.put(lockId, lockEntry);
            }
            lockEntry.incrementLockCount();
            this.lockAccessMonitor.notifyAll();
        }
        boolean lockAcquired = lockEntry.getLock().tryLock();
        if (!lockAcquired) {
            Object object2 = this.lockAccessMonitor;
            synchronized (object2) {
                lockEntry.decrementLockCount();
                if (!lockEntry.hasPendingLocks()) {
                    this.locks.remove(lockId);
                }
            }
        }
        return lockAcquired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockInterruptibly(String lockId) throws InterruptedException {
        LockEntry lockEntry;
        Object object = this.lockAccessMonitor;
        synchronized (object) {
            if (this.locks.containsKey(lockId)) {
                lockEntry = this.locks.get(lockId);
            } else {
                lockEntry = new LockEntry(this.lockProvider.createLock(lockId));
                this.locks.put(lockId, lockEntry);
            }
            lockEntry.incrementLockCount();
            this.lockAccessMonitor.notifyAll();
        }
        lockEntry.getLock().lockInterruptibly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = this.lockAccessMonitor;
        synchronized (object) {
            this.locks.clear();
        }
    }

    public static class LockEntry {
        private AtomicInteger lockCount = new AtomicInteger(0);
        private Lock lock;

        public LockEntry(Lock lock) {
            this.lock = lock;
        }

        public Lock getLock() {
            return this.lock;
        }

        public void incrementLockCount() {
            this.lockCount.incrementAndGet();
        }

        public void decrementLockCount() {
            this.lockCount.decrementAndGet();
        }

        public boolean hasPendingLocks() {
            return this.lockCount.get() > 0;
        }
    }
}

