/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.policy.PolicyStateHandler;
import org.mule.runtime.core.api.policy.PolicyStateId;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.privileged.event.BaseEventContext;

public class DefaultPolicyStateHandler
implements PolicyStateHandler {
    protected MultiMap<String, PolicyStateId> policyStateIdsByExecutionIdentifier = new MultiMap();
    protected Map<PolicyStateId, CoreEvent> stateMap = new HashMap<PolicyStateId, CoreEvent>();
    protected Map<String, Processor> nextOperationMap = new HashMap<String, Processor>();

    @Override
    public synchronized void updateNextOperation(String identifier, Processor nextOperation) {
        throw new UnsupportedOperationException("Use a subscriberContext instead.");
    }

    @Override
    public synchronized Processor retrieveNextOperation(String identifier) {
        throw new UnsupportedOperationException("Use a subscriberContext instead.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<CoreEvent> getLatestState(PolicyStateId identifier) {
        CoreEvent state;
        DefaultPolicyStateHandler defaultPolicyStateHandler = this;
        synchronized (defaultPolicyStateHandler) {
            state = this.stateMap.get(identifier);
        }
        return Optional.ofNullable(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateState(PolicyStateId identifier, CoreEvent lastStateEvent) {
        ((BaseEventContext)lastStateEvent.getContext()).getRootContext().onTerminated((response, throwable) -> this.destroyState(identifier.getExecutionIdentifier()));
        DefaultPolicyStateHandler defaultPolicyStateHandler = this;
        synchronized (defaultPolicyStateHandler) {
            this.stateMap.put(identifier, lastStateEvent);
            this.policyStateIdsByExecutionIdentifier.put(identifier.getExecutionIdentifier(), identifier);
        }
    }

    @Override
    public synchronized void destroyState(String identifier) {
        List<PolicyStateId> policyStateIds = this.policyStateIdsByExecutionIdentifier.removeAll(identifier);
        if (policyStateIds != null) {
            policyStateIds.forEach(this.stateMap::remove);
        }
        this.nextOperationMap.remove(identifier);
    }
}

