/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal;

import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.api.util.func.CheckedSupplier;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;

public class ExtensionResolvingContext {
    private LazyValue<Optional<ConfigurationInstance>> configurationInstance;
    private LazyValue<Optional<ConnectionHandler>> connectionHandler;

    public ExtensionResolvingContext(Supplier<Optional<ConfigurationInstance>> configurationSupplier, ConnectionManager connectionManager) {
        this.configurationInstance = new LazyValue<Supplier<Optional<ConfigurationInstance>>>(configurationSupplier);
        this.connectionHandler = new LazyValue<CheckedSupplier<Optional>>(() -> {
            Optional<ConfigurationInstance> configurationInstance = this.configurationInstance.get();
            if (configurationInstance.isPresent() && configurationInstance.get().getConnectionProvider().isPresent()) {
                return Optional.ofNullable(connectionManager.getConnection(configurationInstance.get().getValue()));
            }
            return Optional.empty();
        });
    }

    public <C> Optional<C> getConfig() {
        return this.configurationInstance.get().map(ConfigurationInstance::getValue);
    }

    public <C> Optional<C> getConnection() throws ConnectionException {
        try {
            return this.connectionHandler.get().map(ConnectionHandler::getConnection);
        }
        catch (Exception e) {
            Optional<ConnectionException> connectionException = ExceptionUtils.extractConnectionException(e);
            throw connectionException.orElse(new ConnectionException(e));
        }
    }

    public void dispose() {
        this.connectionHandler.ifComputed(optionalHandler -> optionalHandler.ifPresent(ConnectionHandler::release));
    }
}

