/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.lang.reflect.Type;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.BinaryTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OutputDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.api.loader.java.type.SourceElement;
import org.mule.runtime.module.extension.internal.loader.annotations.CustomDefinedStaticTypeAnnotation;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.property.MediaTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionOperationDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;

public final class MimeTypeParametersDeclarationEnricher
implements DeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new EnricherDelegate().enrich(extensionLoadingContext);
    }

    private class EnricherDelegate
    extends AbstractAnnotatedDeclarationEnricher {
        private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

        private EnricherDelegate() {
        }

        @Override
        public void enrich(ExtensionLoadingContext extensionLoadingContext) {
            ExtensionDeclaration declaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
            new IdempotentDeclarationWalker(){

                @Override
                protected void onOperation(OperationDeclaration declaration) {
                    EnricherDelegate.this.declareMimeTypeParameters(declaration, declaration.getModelProperty(ExtensionOperationDescriptorModelProperty.class).map(mp -> mp.getOperationReturnType()));
                }

                @Override
                protected void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
                    Optional<org.mule.runtime.module.extension.api.loader.java.type.Type> outputType = declaration.getModelProperty(ExtensionTypeDescriptorModelProperty.class).filter(mp -> mp.getType() instanceof SourceElement).map(mp -> (SourceElement)mp.getType()).map(SourceElement::getReturnType);
                    EnricherDelegate.this.declareMimeTypeParameters(declaration, outputType);
                }
            }.walk(declaration);
        }

        private void declareOutputEncodingParameter(ParameterGroupDeclaration group) {
            group.addParameter(this.newParameter("outputEncoding", "The encoding of the payload that this operation outputs."));
        }

        private void declareOutputMimeTypeParameter(ParameterGroupDeclaration group) {
            group.addParameter(this.newParameter("outputMimeType", "The mime type of the payload that this operation outputs."));
        }

        private void declareMimeTypeParameters(final ExecutableComponentDeclaration<?> declaration, Optional<org.mule.runtime.module.extension.api.loader.java.type.Type> outputType) {
            final MediaTypeModelProperty property = declaration.getModelProperty(MediaTypeModelProperty.class).orElse(null);
            if (property == null) {
                return;
            }
            outputType.map(type -> type.asMetadataType()).orElse(declaration.getOutput().getType()).accept(new MetadataTypeVisitor(){

                @Override
                public void visitString(StringType stringType) {
                    if (stringType.getAnnotation(EnumAnnotation.class).isPresent()) {
                        return;
                    }
                    if (!property.isStrict()) {
                        EnricherDelegate.this.declareOutputMimeTypeParameter(declaration.getParameterGroup("General"));
                    }
                    EnricherDelegate.this.replaceOutputType(declaration, property, format -> {
                        StringTypeBuilder stringTypeBuilder = BaseTypeBuilder.create(format).stringType();
                        this.enrichWithAnnotations(stringTypeBuilder, declaration.getOutput().getType().getAnnotations());
                        return stringTypeBuilder.build();
                    });
                }

                @Override
                public void visitBinaryType(BinaryType binaryType) {
                    if (!property.isStrict()) {
                        ParameterGroupDeclaration group = declaration.getParameterGroup("General");
                        EnricherDelegate.this.declareOutputMimeTypeParameter(group);
                        EnricherDelegate.this.declareOutputEncodingParameter(group);
                    }
                    EnricherDelegate.this.replaceOutputType(declaration, property, format -> {
                        BinaryTypeBuilder builder = BaseTypeBuilder.create(format).binaryType();
                        this.enrichWithAnnotations(builder, declaration.getOutput().getType().getAnnotations());
                        return builder.build();
                    });
                }

                private void enrichWithAnnotations(WithAnnotation withAnnotationBuilder, Set<TypeAnnotation> annotations) {
                    annotations.forEach(typeAnnotation -> withAnnotationBuilder.with((TypeAnnotation)typeAnnotation));
                }
            });
        }

        private void replaceOutputType(ExecutableComponentDeclaration<?> declaration, MediaTypeModelProperty property, Function<MetadataFormat, MetadataType> type) {
            if (!this.shouldOverrideMetadataFormat(declaration)) {
                return;
            }
            property.getMediaType().ifPresent(mediaType -> {
                OutputDeclaration output = declaration.getOutput();
                output.setType((MetadataType)type.apply(ExtensionMetadataTypeUtils.toMetadataFormat(mediaType)), output.hasDynamicType());
            });
        }

        private boolean shouldOverrideMetadataFormat(ExecutableComponentDeclaration declaration) {
            return !declaration.getOutput().getType().getAnnotation(CustomDefinedStaticTypeAnnotation.class).isPresent() && declaration.getOutput().getType().getMetadataFormat().equals(MetadataFormat.JAVA);
        }

        private ParameterDeclaration newParameter(String name, String description) {
            ParameterDeclaration parameter = new ParameterDeclaration(name);
            parameter.setRequired(false);
            parameter.setExpressionSupport(ExpressionSupport.SUPPORTED);
            parameter.setType(this.typeLoader.load((Type)((Object)String.class)), false);
            parameter.setDescription(description);
            parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
            return parameter;
        }
    }
}

