/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.notification;

import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.notification.HasNotifications;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.notification.NotificationActionDefinition;
import org.mule.runtime.extension.api.notification.NotificationEmitter;
import org.mule.runtime.module.extension.internal.runtime.notification.DefaultExtensionNotification;

public class DefaultNotificationEmitter
implements NotificationEmitter {
    private final ServerNotificationManager notificationManager;
    private final CoreEvent event;
    private final Component component;
    private final HasNotifications componentModel;

    public DefaultNotificationEmitter(ServerNotificationManager notificationManager, CoreEvent event, Component component, ComponentModel componentModel) {
        this.notificationManager = notificationManager;
        this.event = event;
        this.component = component;
        this.componentModel = (HasNotifications)((Object)componentModel);
    }

    @Override
    public void fire(NotificationActionDefinition action, TypedValue<?> data) {
        this.validateAction((Enum)((Object)action));
        this.notificationManager.fireNotification(new DefaultExtensionNotification(this.event, this.component, action, data));
    }

    private void validateAction(Enum action) {
        String actionName = action.name();
        for (NotificationModel nm : this.componentModel.getNotificationModels()) {
            if (!actionName.equals(nm.getIdentifier())) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Cannot fire '%s' notification since it's not declared by the component.", actionName));
    }
}

