/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.function.Supplier;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.resolver.ArgumentResolver;

public class ConnectionArgumentResolver
implements ArgumentResolver<Object> {
    @Override
    public Supplier<Object> resolve(ExecutionContext executionContext) {
        return new LazyValue<Object>(() -> {
            ConnectionHandler connectionHandler = (ConnectionHandler)((ExecutionContextAdapter)executionContext).getVariable("MULE_CONNECTION_PARAM");
            Preconditions.checkArgument(connectionHandler != null, "No connection was provided for the component [" + executionContext.getComponentModel().getName() + "]");
            try {
                return connectionHandler.getConnection();
            }
            catch (ConnectionException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Error was found trying to obtain a connection to execute %s '%s' of extension '%s'", NameUtils.getComponentModelTypeName(executionContext.getComponentModel()), executionContext.getComponentModel().getName(), executionContext.getExtensionModel().getName())), (Throwable)e);
            }
        });
    }
}

