/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.model.values.coercion;

import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Locale;
import org.mule.weave.v2.exception.InvalidNumberException;
import org.mule.weave.v2.exception.InvalidUnitException;
import org.mule.weave.v2.exception.UnsupportedTypeCoercionException$;
import org.mule.weave.v2.io.SeekableStream;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.model.types.BinaryType$;
import org.mule.weave.v2.model.types.DateTimeType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.Type;
import org.mule.weave.v2.model.values.NumberValue;
import org.mule.weave.v2.model.values.NumberValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.coercion.NumberUtils;
import org.mule.weave.v2.model.values.coercion.NumberUtils$;
import org.mule.weave.v2.model.values.coercion.ValueCoercer;
import org.mule.weave.v2.parser.ast.structure.schema.TimeUnit$;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.math.BigDecimal$;
import scala.math.BigInt$;
import spire.math.Number;
import spire.math.Number$;

public final class NumberCoercer$
implements ValueCoercer<NumberValue> {
    public static NumberCoercer$ MODULE$;

    static {
        new NumberCoercer$();
    }

    @Override
    public Option<NumberValue> coerceMaybe(Value<?> value, Type targetType, LocationCapable locationCapable, EvaluationContext evaluationContext) {
        return ValueCoercer.coerceMaybe$(this, value, targetType, locationCapable, evaluationContext);
    }

    @Override
    public NumberValue coerce(Value<?> c, Type targetType, LocationCapable locationCapable, EvaluationContext evaluationContext) {
        Type type;
        Type type2;
        Type type3;
        Number number;
        Type type4;
        Option<Schema> schema = targetType.schema(evaluationContext);
        Type type5 = c.valueType(evaluationContext);
        if (type5 != null && (type4 = type5).isInstanceOf(NumberType$.MODULE$, evaluationContext)) {
            number = (Number)c.evaluate(evaluationContext);
        } else if (type5 != null && (type3 = type5).isInstanceOf(DateTimeType$.MODULE$, evaluationContext)) {
            number = this.toNumber(((ZonedDateTime)c.evaluate(evaluationContext)).withZoneSameInstant(ZoneOffset.UTC), schema, locationCapable, evaluationContext);
        } else if (type5 != null && (type2 = type5).isInstanceOf(StringType$.MODULE$, evaluationContext)) {
            number = this.parseNumber((String)c.evaluate(evaluationContext), schema, locationCapable, evaluationContext);
        } else if (type5 != null && (type = type5).isInstanceOf(BinaryType$.MODULE$, evaluationContext)) {
            SeekableStream seekableStream = (SeekableStream)BinaryType$.MODULE$.coerce(c, evaluationContext).evaluate(evaluationContext);
            number = Number$.MODULE$.apply(((InputStream)((Object)seekableStream)).read());
        } else {
            throw UnsupportedTypeCoercionException$.MODULE$.apply(locationCapable.location(), c.valueType(evaluationContext), NumberType$.MODULE$, c, evaluationContext);
        }
        Number number2 = number;
        return NumberValue$.MODULE$.apply(number2, locationCapable, targetType);
    }

    public Number toNumber(ZonedDateTime zonedDateTime, Option<Schema> withSchema, LocationCapable locationCapable, EvaluationContext ctx) {
        Option numberMaybe = withSchema.flatMap((Function1 & Serializable & scala.Serializable)schema -> schema.unit(ctx).map((Function1 & Serializable & scala.Serializable)unit -> NumberCoercer$.toNumber$1(zonedDateTime, unit, zonedDateTime, locationCapable)));
        return (Number)numberMaybe.getOrElse((Function0 & Serializable & scala.Serializable)() -> Number$.MODULE$.apply(NumberCoercer$.toEpochSecond$1(zonedDateTime)));
    }

    public Number parseNumber(String str, Option<Schema> withSchema, LocationCapable locationCapable, EvaluationContext ctx) {
        Number number;
        Option<Schema> option = withSchema;
        if (option instanceof Some) {
            Number number2;
            Some some = (Some)option;
            Schema schema = (Schema)some.value();
            Schema schemaValue = schema;
            Option<String> option2 = schemaValue.format(ctx);
            if (option2 instanceof Some) {
                Number number3;
                Some some2 = (Some)option2;
                String f = (String)some2.value();
                DecimalFormatSymbols formatSymbols = (DecimalFormatSymbols)schemaValue.locale(ctx).map((Function1 & Serializable & scala.Serializable)locale -> DecimalFormatSymbols.getInstance(Locale.forLanguageTag(locale))).getOrElse((Function0 & Serializable & scala.Serializable)() -> DecimalFormatSymbols.getInstance(Locale.getDefault(Locale.Category.FORMAT)));
                DecimalFormat formatter = new DecimalFormat(f, formatSymbols);
                formatter.setParseBigDecimal(true);
                java.lang.Number number4 = formatter.parse(str);
                if (number4 instanceof Integer) {
                    Integer n = (Integer)number4;
                    number3 = Number$.MODULE$.apply(n.intValue());
                } else if (number4 instanceof Long) {
                    Long l = (Long)number4;
                    number3 = Number$.MODULE$.apply(l.longValue());
                } else if (number4 instanceof Double) {
                    Double d = (Double)number4;
                    number3 = Number$.MODULE$.apply(d.doubleValue());
                } else if (number4 instanceof Float) {
                    Float f2 = (Float)number4;
                    number3 = Number$.MODULE$.apply(f2.floatValue());
                } else if (number4 instanceof BigInteger) {
                    BigInteger bigInteger = (BigInteger)number4;
                    number3 = Number$.MODULE$.apply(BigInt$.MODULE$.javaBigInteger2bigInt(bigInteger));
                } else if (number4 instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)number4;
                    number3 = Number$.MODULE$.apply(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(bigDecimal));
                } else {
                    throw new MatchError((Object)number4);
                }
                number2 = number3;
            } else {
                number2 = this.parseNumber(str, locationCapable, ctx);
            }
            number = number2;
        } else {
            number = this.parseNumber(str, locationCapable, ctx);
        }
        return number;
    }

    private Number parseNumber(String str, LocationCapable locationCapable, EvaluationContext ctx) {
        NumberUtils.ParsingResult result = NumberUtils$.MODULE$.fromString(str);
        if (result.resultType() == NumberUtils$.MODULE$.INVALID_DATA()) {
            throw new InvalidNumberException(locationCapable.location(), str, ctx);
        }
        return (Number)result.number().get();
    }

    private static final long toEpochSecond$1(ZonedDateTime zonedDateTime$1) {
        return zonedDateTime$1.toEpochSecond();
    }

    private static final Number toNumber$1(ZonedDateTime zonedDateTime, String unit, ZonedDateTime zonedDateTime$1, LocationCapable locationCapable$1) {
        Number number;
        String string = unit.toLowerCase();
        String string2 = TimeUnit$.MODULE$.MILLISECONDS();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            number = Number$.MODULE$.apply(zonedDateTime.toInstant().toEpochMilli());
        } else {
            String string4 = TimeUnit$.MODULE$.SECONDS();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                number = Number$.MODULE$.apply(NumberCoercer$.toEpochSecond$1(zonedDateTime$1));
            } else {
                throw new InvalidUnitException(locationCapable$1.location(), unit);
            }
        }
        return number;
    }

    private NumberCoercer$() {
        MODULE$ = this;
        ValueCoercer.$init$(this);
    }
}

